/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded;

import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedContainer;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.EmbeddedLifecycle;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Ports;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
public class Server {
    private static final Map<String, Server> servers = new HashMap<String, Server>();
    private final String serverName;
    private final boolean loggerEnabled;
    private final boolean verbose;
    private final File loggerFile;
    private final ContainerStatus status = new ContainerStatus();
    private final Inhabitant<EmbeddedFileSystem> fileSystem;
    private final Habitat habitat;
    private final List<Container> containers = new ArrayList<Container>();

    private Server(Builder builder, Properties properties) {
        EmbeddedFileSystem fs;
        File f;
        this.serverName = builder.serverName;
        this.loggerEnabled = builder.loggerEnabled;
        this.verbose = builder.verbose;
        this.loggerFile = builder.loggerFile;
        File instanceRoot = null;
        if (builder.fileSystem == null || builder.fileSystem.instanceRoot == null) {
            try {
                f = File.createTempFile("gfembed", "tmp", new File(System.getProperty("user.dir")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            f.delete();
            instanceRoot = new File(f.getParent(), f.getName());
            EmbeddedFileSystem.Builder fsBuilder = new EmbeddedFileSystem.Builder();
            if (builder.fileSystem != null) {
                fsBuilder.installRoot(builder.fileSystem.installRoot, builder.fileSystem.cookedMode);
                fsBuilder.configurationFile(builder.fileSystem.configFile);
                fsBuilder.readOnly = builder.fileSystem.readOnlyConfigFile;
            }
            fsBuilder.instanceRoot(instanceRoot);
            fsBuilder.autoDelete(true);
            fs = fsBuilder.build();
        } else {
            fs = builder.fileSystem;
        }
        if (!fs.instanceRoot.exists()) {
            fs.instanceRoot.mkdirs();
            f = new File(fs.instanceRoot, "docroot");
            if (!f.mkdirs() && Logger.getAnonymousLogger().isLoggable(Level.FINE)) {
                Logger.getAnonymousLogger().fine("Cannot create docroot embedded directory at " + f.getAbsolutePath());
            }
            if (!(f = new File(fs.instanceRoot, "config")).mkdirs() && Logger.getAnonymousLogger().isLoggable(Level.FINE)) {
                Logger.getAnonymousLogger().fine("Cannot create config embedded directory at " + f.getAbsolutePath());
            }
        }
        this.fileSystem = new ExistingSingletonInhabitant<EmbeddedFileSystem>(fs);
        PlatformMain embedded = this.getMain();
        if (embedded == null) {
            throw new RuntimeException("Embedded startup not found, classpath is probably incomplete");
        }
        String[] args = new String[]{};
        if (properties != null && properties.containsKey("hk2.startup.context.moduleStartup")) {
            args = new String[]{"-hk2.startup.context.moduleStartup", properties.getProperty("hk2.startup.context.moduleStartup")};
        }
        if (fs.installRoot == null) {
            embedded.setContext(new StartupContext(fs.instanceRoot, fs.instanceRoot, args));
            System.setProperty("com.sun.aas.installRoot", fs.instanceRoot.getAbsolutePath());
        } else {
            embedded.setContext(new StartupContext(fs.installRoot, fs.instanceRoot, args));
            System.setProperty("com.sun.aas.installRoot", fs.installRoot.getAbsolutePath());
        }
        System.setProperty("com.sun.aas.instanceRoot", fs.instanceRoot.getAbsolutePath());
        embedded.setContext(this);
        embedded.setLogger(Logger.getAnonymousLogger());
        try {
            embedded.start(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.habitat = embedded.getStartedService(Habitat.class);
        this.habitat.addIndex(this.fileSystem, EmbeddedFileSystem.class.getName(), null);
        for (EmbeddedLifecycle lifecycle : this.habitat.getAllByContract(EmbeddedLifecycle.class)) {
            try {
                lifecycle.creation(this);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Exception while notifying of embedded server startup", e);
            }
        }
    }

    public static List<String> getServerNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(servers.keySet());
        return names;
    }

    public static Server getServer(String name) {
        return servers.get(name);
    }

    public ContainerBuilder<EmbeddedContainer> createConfig(ContainerBuilder.Type type2) {
        return this.createConfig(type2.toString());
    }

    public ContainerBuilder<EmbeddedContainer> createConfig(String name) {
        return this.habitat.getComponent(ContainerBuilder.class, name);
    }

    public <T extends ContainerBuilder<?>> T createConfig(Class<T> configType) {
        return (T)((ContainerBuilder)this.habitat.getComponent(configType));
    }

    public synchronized void addContainer(final ContainerBuilder.Type type2) {
        if (this.status.isStarted()) {
            throw new IllegalStateException("Cannot add container to a started embedded instance");
        }
        this.containers.add(new Container(new EmbeddedContainer(){
            final List<Container> delegates = new ArrayList<Container>();
            final ArrayList<Sniffer> sniffers = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Sniffer> getSniffers() {
                ArrayList<Sniffer> arrayList = this.sniffers;
                synchronized (arrayList) {
                    if (this.sniffers.isEmpty()) {
                        if (type2 == ContainerBuilder.Type.all) {
                            for (ContainerBuilder.Type t : ContainerBuilder.Type.values()) {
                                if (t == ContainerBuilder.Type.all) continue;
                                this.delegates.add(this.getContainerFor(t));
                            }
                        } else {
                            this.delegates.add(this.getContainerFor(type2));
                        }
                    }
                    for (Container c : this.delegates) {
                        this.sniffers.addAll(c.container.getSniffers());
                    }
                }
                return this.sniffers;
            }

            @Override
            public void bind(Port port, String protocol) {
                for (Container delegate : this.delegates) {
                    delegate.container.bind(port, protocol);
                }
            }

            private Container getContainerFor(final ContainerBuilder.Type type22) {
                ContainerBuilder<EmbeddedContainer> b = Server.this.createConfig(type22);
                if (b != null) {
                    return new Container(b.create(Server.this));
                }
                return new Container(new EmbeddedContainer(){

                    @Override
                    public List<Sniffer> getSniffers() {
                        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
                        Sniffer s = Server.this.habitat.getComponent(Sniffer.class, type22.toString());
                        if (s != null) {
                            sniffers.add(s);
                        }
                        return sniffers;
                    }

                    @Override
                    public void bind(Port port, String protocol) {
                    }

                    @Override
                    public void start() throws LifecycleException {
                    }

                    @Override
                    public void stop() throws LifecycleException {
                    }
                });
            }

            @Override
            public void start() throws LifecycleException {
                for (Container c : this.delegates) {
                    if (c.started) continue;
                    c.container.start();
                    c.started = true;
                }
            }

            @Override
            public void stop() throws LifecycleException {
                for (Container c : this.delegates) {
                    if (!c.started) continue;
                    c.container.stop();
                    c.started = false;
                }
            }
        }));
    }

    public synchronized <T extends EmbeddedContainer> T addContainer(ContainerBuilder<T> info) {
        if (this.status.isStarted()) {
            throw new IllegalStateException("Cannot add containers to an already started embedded instance");
        }
        T container = info.create(this);
        if (container != null && this.containers.add(new Container((EmbeddedContainer)container))) {
            return container;
        }
        return null;
    }

    public Collection<EmbeddedContainer> getContainers() {
        ArrayList<EmbeddedContainer> copy = new ArrayList<EmbeddedContainer>();
        for (Container c : this.containers) {
            copy.add(c.container);
        }
        return copy;
    }

    public Port createPort(int portNumber) throws IOException {
        Ports ports = this.habitat.getComponent(Ports.class);
        return ports.createPort(portNumber);
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public String getName() {
        return this.serverName;
    }

    public EmbeddedFileSystem getFileSystem() {
        return this.fileSystem.get();
    }

    public synchronized void start() throws LifecycleException {
        if (this.status.isStarted()) {
            return;
        }
        for (Container c : this.containers) {
            try {
                c.container.start();
                c.started = true;
            }
            catch (LifecycleException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot start embedded container", e);
                c.started = false;
            }
        }
        this.status.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws LifecycleException {
        try {
            if (this.status.isStopped()) {
                return;
            }
            for (Container container : this.containers) {
                try {
                    if (!container.started) continue;
                    container.container.stop();
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "Exception while closing a embedded container", e);
                }
                finally {
                    container.started = false;
                }
            }
            ModuleStartup ms = this.habitat.getComponent(ModuleStartup.class, this.habitat.DEFAULT_NAME);
            if (ms != null) {
                ms.stop();
            }
            Map<String, Server> map = servers;
            synchronized (map) {
                servers.remove(this.serverName);
            }
            this.status.stopped();
            for (EmbeddedLifecycle lifecycle : this.habitat.getAllByContract(EmbeddedLifecycle.class)) {
                try {
                    lifecycle.destruction(this);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "Exception while notifying of embedded server destruction", e);
                }
            }
        }
        finally {
            this.fileSystem.get().preDestroy();
        }
    }

    public EmbeddedDeployer getDeployer() {
        return this.habitat.getByContract(EmbeddedDeployer.class);
    }

    private PlatformMain getMain() {
        String platformName = "Embedded";
        if (this.fileSystem.get().installRoot != null && this.fileSystem.get().installRoot.exists() && !this.fileSystem.get().cookedMode) {
            platformName = "Static";
        }
        ServiceLoader<PlatformMain> mains = ServiceLoader.load(PlatformMain.class, Server.class.getClassLoader());
        for (PlatformMain main : mains) {
            if (!platformName.equals(main.getName())) continue;
            return main;
        }
        return null;
    }

    private static final class Container {
        private final EmbeddedContainer container;
        boolean started;

        private Container(EmbeddedContainer container) {
            this.container = container;
        }
    }

    private static final class ContainerStatus {
        int status = 0;

        private ContainerStatus() {
        }

        private void started() {
            this.status = 1;
        }

        private void stopped() {
            this.status = 0;
        }

        private boolean isStopped() {
            return this.status == 0;
        }

        private boolean isStarted() {
            return this.status == 1;
        }
    }

    public static class Builder {
        final String serverName;
        boolean loggerEnabled;
        boolean verbose;
        File loggerFile;
        EmbeddedFileSystem fileSystem;

        public Builder(String id) {
            this.serverName = id;
        }

        public Builder logger(boolean enabled) {
            this.loggerEnabled = enabled;
            return this;
        }

        public Builder logFile(File f) {
            this.loggerFile = f;
            return this;
        }

        public Builder verbose(boolean b) {
            this.verbose = b;
            return this;
        }

        public Builder embeddedFileSystem(EmbeddedFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Server build() {
            return this.build(null);
        }

        public Server build(Properties properties) {
            Map map = servers;
            synchronized (map) {
                if (!servers.containsKey(this.serverName)) {
                    Server s = new Server(this, properties);
                    servers.put(this.serverName, s);
                    return s;
                }
                throw new IllegalStateException("An embedded server of this name already exists");
            }
        }
    }
}

