/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandParameters;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand,
EventListener {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";
    @Inject
    Applications apps;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;
    @Inject
    DownloadableArtifacts downloadableArtifacts;
    @Inject
    Events events;
    private PayloadFilesManager.Temp payloadFilesMgr = null;
    private List<File> payloadFiles = null;

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    /*
     * Exception decompiling
     */
    public void execute(AdminCommandContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File choosePathFile(AdminCommandContext context) {
        if (this.payloadFiles.size() >= 1) {
            return this.payloadFiles.get(0);
        }
        return this.path;
    }

    private File chooseDeploymentPlanFile(AdminCommandContext context) {
        if (this.payloadFiles.size() >= 2) {
            return this.payloadFiles.get(1);
        }
        return this.deploymentplan;
    }

    private Properties handleRedeploy(String name, ActionReport report) throws Exception {
        boolean isRegistered = this.deployment.isRegistered(name);
        if (isRegistered && !this.force.booleanValue()) {
            String msg = localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name});
            throw new Exception(msg);
        }
        if (isRegistered && this.force.booleanValue()) {
            com.sun.enterprise.config.serverbeans.Application app = (com.sun.enterprise.config.serverbeans.Application)this.apps.getModule(com.sun.enterprise.config.serverbeans.Application.class, name);
            this.settingsFromDomainXML(app);
            UndeployCommandParameters undeployParams = new UndeployCommandParameters(name);
            undeployParams.keepreposdir = this.keepreposdir;
            undeployParams.droptables = this.dropandcreatetables;
            undeployParams.ignoreCascade = this.force;
            ActionReport subReport = report.addSubActionsReport();
            if (this.properties != null && this.properties.containsKey("keepSessions")) {
                undeployParams.properties = new Properties();
                undeployParams.properties.put("keepSessions", this.properties.getProperty("keepSessions"));
                subReport.setExtraProperties(new Properties());
            } else if (this.property != null && this.property.containsKey("keepSessions")) {
                undeployParams.properties = new Properties();
                undeployParams.properties.put("keepSessions", this.property.getProperty("keepSessions"));
                subReport.setExtraProperties(new Properties());
            }
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", subReport);
            inv.parameters((CommandParameters)undeployParams).execute();
            return subReport.getExtraProperties();
        }
        return null;
    }

    public static void retrieveArtifacts(AdminCommandContext context, String appName, String targetLocalDir, DownloadableArtifacts downloadableArtifacts) {
        DeployCommand.retrieveArtifacts(context, appName, targetLocalDir, downloadableArtifacts, true);
    }

    public static void retrieveArtifacts(AdminCommandContext context, String appName, String targetLocalDir, DownloadableArtifacts downloadableArtifacts, boolean reportErrorsInTopReport) {
        Logger logger = context.getLogger();
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            Properties props = new Properties();
            props.setProperty("file-xfer-root", targetLocalDir);
            for (DownloadableArtifacts.FullAndPartURIs uriPair : downloadableArtifacts.getArtifacts(appName)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "About to download artifact " + uriPair.getFull());
                }
                outboundPayload.attachFile("application/octet-stream", uriPair.getPart(), "files", props, new File(uriPair.getFull().getSchemeSpecificPart()));
            }
        }
        catch (Exception e) {
            String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
            logger.log(Level.SEVERE, errorMsg, e);
            ActionReport report = context.getActionReport();
            if (!reportErrorsInTopReport) {
                report = report.addSubActionsReport();
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
        }
    }

    private void settingsFromDomainXML(com.sun.enterprise.config.serverbeans.Application app) {
        if (this.name != null) {
            String compatProp;
            if (this.contextroot == null && app.getContextRoot() != null) {
                this.previousContextRoot = app.getContextRoot();
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            if (this.virtualservers == null) {
                this.virtualservers = ConfigBeansUtilities.getVirtualServers((String)this.target, (String)this.name);
            }
            if ((compatProp = app.getDeployProperties().getProperty("compatibility")) != null) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                if (this.properties.getProperty("compatibility") == null) {
                    this.properties.setProperty("compatibility", compatProp);
                }
            }
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            DeploymentContext context = (DeploymentContext)event.hook();
            if (this.verify.booleanValue()) {
                if (!this.isVerifierInstalled()) {
                    context.getLogger().warning("Verifier is not installed yet. Install verifier module.");
                } else {
                    this.invokeVerifier(context);
                }
            }
        }
    }

    private void invokeVerifier(DeploymentContext context) throws DeploymentException {
        Verifier verifier = this.habitat.getComponent(Verifier.class);
        VerifierFrameworkContext verifierFrameworkContext = new VerifierFrameworkContext();
        verifierFrameworkContext.setArchive((Archive)context.getSource());
        verifierFrameworkContext.setApplication((Application)context.getModuleMetaData(Application.class));
        verifierFrameworkContext.setJarFileName(context.getSourceDir().getAbsolutePath());
        verifierFrameworkContext.setJspOutDir(context.getScratchDir("jsp"));
        verifierFrameworkContext.setOutputDirName(this.env.getDomainRoot().getAbsolutePath() + "/logs/verifier-results");
        ResultManager rm = verifierFrameworkContext.getResultManager();
        try {
            verifier.init(verifierFrameworkContext);
            verifier.verify();
        }
        catch (Exception e) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, "Could not verify successfully.");
            logRecord.setThrown(e);
            verifierFrameworkContext.getResultManager().log(logRecord);
        }
        try {
            verifier.generateReports();
        }
        catch (IOException ioe) {
            context.getLogger().warning("Can not generate verifier report: " + ioe.getMessage());
        }
        int failedCount = rm.getFailedCount() + rm.getErrorCount();
        if (failedCount != 0) {
            ((ExtendedDeploymentContext)context).clean();
            throw new DeploymentException(localStrings.getLocalString("deploy.failverifier", "Some verifier tests failed. Aborting deployment"));
        }
    }

    private boolean isVerifierInstalled() {
        try {
            Class.forName("com.sun.enterprise.tools.verifier.Verifier");
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            Logger.getAnonymousLogger().log(Level.FINE, "Verifier class not found: ", cnfe);
            return false;
        }
    }

    private String getVirtualServers() {
        List hosts;
        HttpService httpService;
        Config config;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Server server = this.domain.getServerNamed(this.target);
        if (server != null && (config = this.domain.getConfigs().getConfigByName(server.getConfigRef())) != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }
}

