/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.v3.server.DynamicReloader;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
@Async
public class DynamicReloadService
implements ConfigListener,
Startup,
PostConstruct,
PreDestroy {
    @Inject
    DasConfig activeDasConfig;
    @Inject
    Applications applications;
    @Inject
    Habitat habitat;
    private Logger logger;
    private Timer timer;
    private TimerTask timerTask;
    private DynamicReloader reloader;
    private static final String DEFAULT_POLL_INTERVAL_IN_SECONDS = "2";
    private static final List<String> configPropertyNames = Arrays.asList("dynamic-reload-enabled", "dynamic-reload-poll-interval-in-seconds");

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        this.logger = Logger.getLogger(DynamicReloadService.class.getName());
        try {
            this.logger.fine("[Reloader] ReloaderService starting");
            this.reloader = new DynamicReloader(this.applications, this.habitat);
            this.timer = new Timer("DynamicReloader", true);
            if (this.isEnabled(this.activeDasConfig)) {
                this.start(this.getPollIntervalInSeconds(this.activeDasConfig));
            } else {
                this.logger.fine("[Reloader] Reloader is configured as disabled, so NOT starting the periodic task");
            }
            this.logger.fine("[Reloader] Service start-up complete");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void preDestroy() {
        this.stop();
    }

    static String getValue(String value, String defaultValue) {
        return value == null || value.equals("") ? defaultValue : value;
    }

    private boolean isEnabled(DasConfig config) {
        return Boolean.parseBoolean(config.getDynamicReloadEnabled());
    }

    private int getPollIntervalInSeconds(DasConfig config) {
        int result;
        try {
            result = Integer.parseInt(config.getDynamicReloadPollIntervalInSeconds());
        }
        catch (NumberFormatException e) {
            result = Integer.parseInt(DEFAULT_POLL_INTERVAL_IN_SECONDS);
        }
        return result;
    }

    private void start(int pollIntervalInSeconds) {
        long pollIntervalInMS = (long)pollIntervalInSeconds * 1000L;
        this.timerTask = new TimerTask(){

            public void run() {
                try {
                    DynamicReloadService.this.reloader.run();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.timer.schedule(this.timerTask, pollIntervalInMS, pollIntervalInMS);
        this.logger.fine("[Reloader] Started, monitoring every " + pollIntervalInSeconds + " seconds");
    }

    private void stop() {
        this.logger.fine("[Reloader] Stopping");
        this.reloader.cancel();
        this.timerTask.cancel();
    }

    private void reschedule(int pollIntervalInSeconds) {
        this.logger.fine("[Reloader] Restarting...");
        this.stop();
        try {
            this.reloader.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.start(pollIntervalInSeconds);
    }

    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unprocessedEvents = new ArrayList<UnprocessedChangeEvent>();
        Boolean newEnabled = null;
        Integer newPollIntervalInSeconds = null;
        for (PropertyChangeEvent event : events) {
            String propName = event.getPropertyName();
            if (!(event.getSource() instanceof DasConfig)) continue;
            if (configPropertyNames.contains(propName) && event.getOldValue().equals(event.getNewValue())) {
                this.logger.fine("[DynamicReload] Ignoring reconfig of " + propName + " from " + event.getOldValue() + " to " + event.getNewValue());
                continue;
            }
            if (propName.equals("dynamic-reload-enabled")) {
                newEnabled = Boolean.valueOf((String)event.getNewValue());
                continue;
            }
            if (!propName.equals("dynamic-reload-poll-interval-in-seconds")) continue;
            try {
                newPollIntervalInSeconds = new Integer((String)event.getNewValue());
            }
            catch (NumberFormatException ex) {
                String reason = ex.getClass().getName() + " " + ex.getLocalizedMessage();
                this.logger.log(Level.WARNING, reason);
            }
        }
        if (newEnabled != null) {
            if (newEnabled.booleanValue()) {
                this.start(newPollIntervalInSeconds == null ? this.getPollIntervalInSeconds(this.activeDasConfig) : newPollIntervalInSeconds.intValue());
            } else {
                this.stop();
            }
        } else if (newPollIntervalInSeconds != null && this.isEnabled(this.activeDasConfig)) {
            this.reschedule(newPollIntervalInSeconds);
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }
}

