/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeProviderRegistry {
    private static ProbeProviderRegistry _me = new ProbeProviderRegistry();
    private ConcurrentMap<String, FlashlightProbeProvider> providerMap = new ConcurrentHashMap<String, FlashlightProbeProvider>();

    private ProbeProviderRegistry() {
    }

    public static ProbeProviderRegistry getInstance() {
        return _me;
    }

    public static void cleanup() {
        _me = new ProbeProviderRegistry();
    }

    public Collection<FlashlightProbeProvider> getAllProbeProviders() {
        return Collections.unmodifiableCollection(this.providerMap.values());
    }

    public FlashlightProbeProvider getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName) {
        if (probeProviderName == null) {
            probeProviderName = "";
        }
        return (FlashlightProbeProvider)this.providerMap.get(FlashlightUtils.makeName(moduleProviderName, moduleName, probeProviderName));
    }

    public FlashlightProbeProvider getProbeProvider(FlashlightProbeProvider fpp) {
        return (FlashlightProbeProvider)this.providerMap.get(FlashlightUtils.makeName(fpp));
    }

    public FlashlightProbeProvider registerProbeProvider(FlashlightProbeProvider provider, Class clz) {
        String qname = FlashlightUtils.makeName(provider);
        if (this.providerMap.putIfAbsent(qname, provider) != null) {
            throw new IllegalStateException("Provider already mapped " + qname);
        }
        return provider;
    }
}

