/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMap {
    private final Map<String, List<String>> store;

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        String newline = System.getProperty("line.separator");
        builder.append("{");
        for (String key : this.store.keySet()) {
            builder.append(key + ": {");
            for (String value : this.store.get(key)) {
                builder.append(value.toString() + ",");
            }
            builder.append("}" + newline);
        }
        builder.append("}");
        return builder.toString();
    }

    public ParameterMap() {
        this.store = new HashMap<String, List<String>>();
    }

    private ParameterMap(Map<String, List<String>> store) {
        this.store = store;
    }

    public ParameterMap(ParameterMap base) {
        this();
        for (Map.Entry<String, List<String>> e : base.entrySet()) {
            this.store.put(e.getKey(), new ArrayList(e.getValue()));
        }
    }

    public final void add(String k, String v) {
        List<String> l = this.store.get(k);
        if (l == null) {
            l = new ArrayList<String>();
            this.store.put(k, l);
        }
        l.add(v);
    }

    public void set(String k, Collection<String> v) {
        this.store.put(k, new ArrayList<String>(v));
    }

    public void set(String k, String v) {
        ArrayList<String> vlist = new ArrayList<String>(1);
        vlist.add(v);
        this.store.put(k, vlist);
    }

    public final List<String> get(String k) {
        List<String> l = this.store.get(k);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    public boolean containsKey(String key) {
        return !this.get(key).isEmpty();
    }

    public final String getOne(String k) {
        List<String> lst = this.store.get(k);
        if (lst == null) {
            return null;
        }
        if (lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.store.entrySet();
    }

    public String toCommaSeparatedString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, List<String>> e : this.entrySet()) {
            for (String v : e.getValue()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(e.getKey()).append('=').append(v);
            }
        }
        return buf.toString();
    }

    public ParameterMap clone() {
        return new ParameterMap(this);
    }

    public int size() {
        return this.store.size();
    }
}

