/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.config.support.ConfigurationPersistence;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;

@Service
@Scoped(value=Singleton.class)
public class DomainXmlPersistence
implements ConfigurationPersistence {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    protected Logger logger;
    final XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(DomDocument doc) throws IOException {
        File destination = this.getDestination();
        if (destination == null) {
            this.logger.fine("domain.xml not persisted, null destination");
            return;
        }
        File f = File.createTempFile("domain", ".xml", destination.getParentFile());
        if (f == null) {
            throw new IOException("Cannot create temporary file when saving domain.xml");
        }
        XMLStreamWriter writer = null;
        OutputStream fos = this.getOutputStream(f);
        try {
            writer = this.xmlFactory.createXMLStreamWriter(new BufferedOutputStream(fos));
            IndentingXMLStreamWriter indentingXMLStreamWriter = new IndentingXMLStreamWriter(writer);
            doc.writeTo(indentingXMLStreamWriter);
            indentingXMLStreamWriter.close();
        }
        catch (XMLStreamException e) {
            this.logger.severe("Temporary file could not be created, disk full?");
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File backup = new File(this.env.getConfigDirPath(), "domain.xml.bak");
        if (backup.exists() && !backup.delete()) {
            this.logger.severe("Could not delete previous backup file at " + backup.getAbsolutePath());
            return;
        }
        if (destination != null) {
            if (!destination.renameTo(backup)) {
                this.logger.severe("Could not rename " + destination.getAbsolutePath() + " to " + backup.getAbsolutePath());
                return;
            }
            if (!f.renameTo(destination)) {
                this.logger.severe("Could not rename " + f.getAbsolutePath() + " to " + destination.getAbsolutePath());
                if (!backup.renameTo(destination)) {
                    this.logger.severe("Could not rename backup to" + destination.getAbsolutePath());
                }
            }
        }
        this.saved(destination);
    }

    protected void saved(File destination) {
        this.logger.fine("Configuration saved at " + destination);
    }

    protected File getDestination() throws IOException {
        return new File(this.env.getConfigDirPath(), "domain.xml");
    }

    protected OutputStream getOutputStream(File destination) throws IOException {
        return new FileOutputStream(destination);
    }
}

