/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.GeneratedManPageManager;
import com.sun.enterprise.admin.remote.RemoteException;
import com.sun.enterprise.admin.remote.RemoteFailureException;
import com.sun.enterprise.admin.remote.RemoteSuccessException;
import com.sun.enterprise.admin.remote.ResponseManager;
import com.sun.enterprise.universal.NameValue;
import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.glassfish.AdminCommandResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManifestManager
implements ResponseManager {
    private Logger logger;
    private AdminCommandResponse response;
    private static final String EOL = StringUtils.EOL;
    private static final String TAB = "    ";

    ManifestManager(InputStream inStream, Logger logger) throws RemoteException, IOException {
        this.logger = logger;
        this.response = new AdminCommandResponse(inStream);
    }

    public Map<String, String> getMainAtts() {
        return this.response.getMainAtts();
    }

    @Override
    public void process() throws RemoteException {
        this.logger.finer("PROCESSING MANIFEST...");
        this.processGeneratedManPage();
        this.processManPage();
        this.processGeneric();
        throw new RemoteFailureException("Could not process");
    }

    private void processManPage() throws RemoteSuccessException {
        String manPage = this.response.getValue("MANPAGE");
        if (!this.ok(manPage)) {
            return;
        }
        throw new RemoteSuccessException(manPage);
    }

    private void processGeneratedManPage() throws RemoteException {
        if (!this.response.isGeneratedHelp()) {
            return;
        }
        GeneratedManPageManager mgr = new GeneratedManPageManager(this.response);
        mgr.process();
    }

    private void processGeneric() throws RemoteSuccessException, RemoteFailureException {
        boolean useMainChildrenAttr;
        StringBuilder sb = new StringBuilder();
        String msg = this.response.getMainMessage();
        if (this.ok(msg)) {
            sb.append(msg).append(EOL);
        }
        if (useMainChildrenAttr = Boolean.valueOf(this.response.getMainAtts().get("use-main-children-attribute")).booleanValue()) {
            sb = this.processMainChildrenAttribute(this.response.getMainAtts(), sb);
        } else {
            this.processOneLevel("", null, this.response.getMainAtts(), sb);
        }
        if (!this.response.wasSuccess()) {
            String cause = this.response.getCause();
            if (this.ok(cause)) {
                if (this.logger.isLoggable(Level.FINER)) {
                    sb.append(cause);
                }
                throw new RemoteFailureException(sb.toString(), cause);
            }
            throw new RemoteFailureException(sb.toString());
        }
        throw new RemoteSuccessException(sb.toString());
    }

    private void processOneLevel(String prefix, String key, Map<String, String> atts, StringBuilder sb) {
        if (atts == null) {
            return;
        }
        this.processChildren(prefix, key, atts, sb);
    }

    private void processProps(String prefix, Map<String, String> atts, StringBuilder sb) {
        List<NameValue<String, String>> props = this.response.getKeys(atts);
        Iterator<NameValue<String, String>> it = props.iterator();
        while (it.hasNext()) {
            NameValue<String, String> nv = it.next();
            if (!nv.getName().startsWith("nb-")) continue;
            it.remove();
        }
        if (props == null || props.isEmpty()) {
            return;
        }
        sb.append(prefix).append("properties=(");
        boolean first = true;
        for (NameValue<String, String> nv : props) {
            String name = nv.getName();
            String value = nv.getValue();
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(name + "=" + value);
        }
        sb.append(")").append(EOL);
    }

    private void processChildren(String prefix, String parent, Map<String, String> atts, StringBuilder sb) {
        Map<String, Map<String, String>> kids = this.response.getChildren(atts);
        if (kids == null || kids.isEmpty()) {
            return;
        }
        String childrenType = atts.get("children-type");
        int index = parent == null ? 0 : parent.length() + 1;
        for (Map.Entry<String, Map<String, String>> entry : kids.entrySet()) {
            String container = entry.getKey();
            if (this.ok(childrenType)) {
                sb.append(prefix).append(childrenType).append(" : ");
            }
            try {
                sb.append(URLDecoder.decode(container.substring(index), "UTF-8")).append(EOL);
            }
            catch (Exception e) {
                sb.append(container.substring(index)).append(EOL);
            }
            this.processOneLevel(prefix + TAB, container, entry.getValue(), sb);
        }
    }

    private StringBuilder processMainChildrenAttribute(Map<String, String> atts, StringBuilder sb) {
        String allChildren = atts.get("children");
        if (this.ok(allChildren)) {
            String[] children;
            for (String child : children = allChildren.split(";")) {
                sb.append(this.decode(child)).append(EOL);
            }
        }
        return sb;
    }

    private void dump() {
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    private String decode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
        catch (IllegalArgumentException e1) {
            return value;
        }
    }
}

