/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InjectionResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Lead;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantRequested;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Womb;
import org.jvnet.tiger_types.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWombImpl<T>
extends AbstractInhabitantImpl<T>
implements Womb<T> {
    protected final Class<T> type;
    private final MultiMap<String, String> metadata;
    private final InjectionManager injectionMgr = new InjectionManager();

    public AbstractWombImpl(Class<T> type, MultiMap<String, String> metadata) {
        this.type = type;
        this.metadata = metadata;
    }

    @Override
    public final String typeName() {
        return this.type.getName();
    }

    @Override
    public final Class<T> type() {
        return this.type;
    }

    @Override
    public final T get(Inhabitant onBehalfOf) throws ComponentException {
        Object o = this.create(onBehalfOf);
        if (o instanceof InhabitantRequested) {
            ((InhabitantRequested)o).setInhabitant(onBehalfOf);
        }
        this.initialize(o, onBehalfOf);
        return o;
    }

    @Override
    public boolean isInstantiated() {
        return false;
    }

    @Override
    public void initialize(T t, Inhabitant onBehalfOf) throws ComponentException {
    }

    @Override
    public void release() {
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.metadata;
    }

    protected void inject(final Habitat habitat, T t, final Inhabitant onBehalfOf) {
        InjectionResolver[] targets = new InjectionResolver[]{new InjectionResolver<Inject>(Inject.class){

            @Override
            public boolean isOptional(AnnotatedElement element, Inject annotation) {
                return annotation.optional();
            }

            @Override
            public <V> V getValue(Object component, AnnotatedElement target, Class<V> type) throws ComponentException {
                if (type.isArray()) {
                    Class<?> ct = type.getComponentType();
                    Collection<?> instances = habitat.isContract(ct) ? habitat.getAllByContract(ct) : habitat.getAllByType(ct);
                    return type.cast(instances.toArray((Object[])Array.newInstance(ct, instances.size())));
                }
                if (Types.isSubClassOf(type, Holder.class)) {
                    Type t = Types.getTypeArgument(((Field)target).getGenericType(), 0);
                    Class finalType = Types.erasure(t);
                    if (habitat.isContract(finalType)) {
                        return type.cast(habitat.getInhabitants(finalType, target.getAnnotation(Inject.class).name()));
                    }
                    try {
                        if (finalType.cast(component) != null) {
                            return type.cast(onBehalfOf);
                        }
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    return type.cast(habitat.getInhabitantByType(finalType));
                }
                if (habitat.isContract(type)) {
                    return habitat.getComponent(type, target.getAnnotation(Inject.class).name());
                }
                return habitat.getByType(type);
            }
        }, new InjectionResolver<Lead>(Lead.class){

            @Override
            public <V> V getValue(Object component, AnnotatedElement target, Class<V> type) throws ComponentException {
                Inhabitant lead = onBehalfOf.lead();
                if (lead == null) {
                    throw new ComponentException(component.getClass() + " requested @Lead injection but this is not a companion");
                }
                if (type == Inhabitant.class) {
                    return type.cast(lead);
                }
                return type.cast(lead.get());
            }
        }};
        this.injectionMgr.inject(t, targets);
        if (t instanceof PostConstruct) {
            ((PostConstruct)t).postConstruct();
        }
    }
}

