/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.DomainXmlReader;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public abstract class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    Logger logger;
    @Inject
    protected Habitat habitat;
    @Inject
    ModulesRegistry registry;
    @Inject
    XMLInputFactory xif;
    @Inject
    ServerEnvironmentImpl env;

    public void run(ConfigParser parser) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Startup class : " + this.getClass().getName());
        }
        this.habitat.addComponent("parent-class-loader", new ExistingSingletonInhabitant<ClassLoader>(ClassLoader.class, this.registry.getParentClassLoader()));
        try {
            this.parseDomainXml(parser, this.getDomainXml(this.env), this.env.getInstanceName());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse domain.xml", e);
        }
        if ("upgrade".equals(this.context.getPlatformMainServiceName())) {
            this.upgrade();
        }
        this.decorate();
    }

    protected void decorate() {
        Server server = this.habitat.getComponent(Server.class, this.env.getInstanceName());
        this.habitat.addIndex(new ExistingSingletonInhabitant<Server>(server), Server.class.getName(), "default-instance-name");
        this.habitat.addIndex(new ExistingSingletonInhabitant<Config>(this.habitat.getComponent(Config.class, server.getConfigRef())), Config.class.getName(), "default-instance-name");
    }

    protected void upgrade() {
        for (Inhabitant<ConfigurationUpgrade> cu : this.habitat.getInhabitants(ConfigurationUpgrade.class)) {
            try {
                cu.get();
                Logger.getAnonymousLogger().fine("Successful Upgrade domain.xml with " + cu.getClass());
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.FINE, e.toString(), e);
                Logger.getAnonymousLogger().severe(cu.getClass() + " upgrading domain.xml failed " + e);
            }
        }
    }

    protected URL getDomainXml(ServerEnvironmentImpl env) throws IOException {
        return new File(env.getConfigDirPath(), "domain.xml").toURI().toURL();
    }

    protected void parseDomainXml(ConfigParser parser, URL domainXml, String serverName) {
        try {
            DomainXmlReader xsr = null;
            if (this.env.getRuntimeType() == RuntimeType.DAS) {
                xsr = new DomainXmlReader(domainXml, this.xif, this.logger);
            } else if (this.env.getRuntimeType() == RuntimeType.INSTANCE) {
                xsr = new DomainXmlReader(domainXml, this.env.getInstanceName(), this.xif, this.logger);
            } else {
                throw new RuntimeException("Internal Error: Unknown server type: " + this.env.getRuntimeType());
            }
            parser.parse(xsr, this.getDomDocument());
            xsr.close();
            String errorMessage = xsr.configWasFound();
            if (errorMessage != null) {
                this.logger.warning(errorMessage);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Fatal Error.  Unable to parse " + domainXml, e);
        }
    }

    protected abstract DomDocument getDomDocument();
}

