/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericCommandModel
extends CommandModel {
    final HashMap<String, CommandModel.ParamModel> params = new HashMap();
    final String commandName;
    final Cluster cluster;

    public GenericCommandModel(Class<?> targetType, Cluster cluster, DomDocument document, String commandName, Class<?> ... extraTypes) {
        this.commandName = commandName;
        this.cluster = cluster;
        if (targetType != null && ConfigBeanProxy.class.isAssignableFrom(targetType)) {
            ConfigModel cm = document.buildModel(targetType);
            for (Method m : targetType.getMethods()) {
                ConfigModel.Property prop = cm.toProperty(m);
                if (prop == null) continue;
                String attributeName = prop.xmlName;
                if (!m.isAnnotationPresent(Param.class)) continue;
                Param p = m.getAnnotation(Param.class);
                if (p.name() != null && !p.name().isEmpty()) {
                    this.params.put(p.name(), new ParamBasedModel(p.name(), p));
                    continue;
                }
                if (!m.isAnnotationPresent(Attribute.class)) continue;
                Attribute attr = m.getAnnotation(Attribute.class);
                if (attr.value() != null && !attr.value().isEmpty()) {
                    this.params.put(attr.value(), new AttributeBasedModel(attr.value(), attr));
                    continue;
                }
                this.params.put(attributeName, new AttributeBasedModel(attributeName, attr));
            }
        }
        if (extraTypes != null) {
            for (Class<?> extraType : extraTypes) {
                CommandModelImpl cm = new CommandModelImpl();
                cm.init(extraType);
                for (String paramName : cm.getParametersNames()) {
                    this.params.put(paramName, cm.getModelFor(paramName));
                }
            }
        }
    }

    public I18n getI18n() {
        return null;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public CommandModel.ParamModel getModelFor(String paramName) {
        return this.params.get(paramName);
    }

    public Collection<String> getParametersNames() {
        return this.params.keySet();
    }

    public Cluster getClusteringAttributes() {
        return this.cluster;
    }

    private final class AttributeBasedModel
    extends CommandModel.ParamModel {
        final String name;
        final Attribute attr;

        private AttributeBasedModel(String name, Attribute attr) {
            this.name = name;
            this.attr = attr;
        }

        public String getName() {
            return this.name;
        }

        public I18n getI18n() {
            return null;
        }

        public Class getType() {
            return String.class;
        }

        public Param getParam() {
            return new Param(){

                public Class<? extends Annotation> annotationType() {
                    return Param.class;
                }

                public String name() {
                    return AttributeBasedModel.this.name;
                }

                public String acceptableValues() {
                    return null;
                }

                public boolean optional() {
                    return !AttributeBasedModel.this.attr.key();
                }

                public String shortName() {
                    return null;
                }

                public boolean primary() {
                    return AttributeBasedModel.this.attr.key();
                }

                public String defaultValue() {
                    return AttributeBasedModel.this.attr.defaultValue();
                }

                public boolean password() {
                    return false;
                }

                public char separator() {
                    return ',';
                }

                public boolean multiple() {
                    return false;
                }

                public boolean obsolete() {
                    return false;
                }
            };
        }
    }

    private final class ParamBasedModel
    extends CommandModel.ParamModel {
        final String name;
        final Param param;

        private ParamBasedModel(String name, Param param) {
            this.name = name;
            this.param = param;
        }

        public String getName() {
            return this.name;
        }

        public Param getParam() {
            return this.param;
        }

        public I18n getI18n() {
            return null;
        }

        public Class getType() {
            return String.class;
        }
    }
}

