/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWebSocket
implements WebSocket {
    protected static final Logger logger = Logger.getLogger("websocket");
    protected State state = State.STARTING;
    private final Set<WebSocketListener> listeners = new LinkedHashSet<WebSocketListener>();
    private final Queue<DataFrame> incoming = new ConcurrentLinkedQueue<DataFrame>();
    private Selector selector;
    private boolean connected = false;

    public Set<WebSocketListener> getListeners() {
        return this.listeners;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector sel) {
        this.selector = sel;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean conn) {
        this.connected = conn;
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void close() throws IOException {
        this.onClose();
        this.connected = false;
        this.state = State.CLOSED;
        this.incoming.clear();
        this.listeners.clear();
    }

    @Override
    public void onClose() {
        for (WebSocketListener listener : this.listeners) {
            listener.onClose(this);
        }
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void send(String data) {
        this.send(new DataFrame(data));
    }

    private void send(DataFrame frame) {
        try {
            this.write(frame.frame());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected DataFrame incoming() {
        return this.incoming.poll();
    }

    protected void doConnect() throws IOException {
        this.connected = true;
        this.onConnect();
    }

    @Override
    public void onConnect() {
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
    }

    protected void doRead() throws IOException {
        this.unframe();
    }

    @Override
    public void onMessage() {
        DataFrame frame;
        while ((frame = this.incoming()) != null) {
            for (WebSocketListener listener : this.listeners) {
                listener.onMessage(this, frame);
            }
        }
    }

    protected void unframe(ByteBuffer bytes) throws IOException {
        while (bytes.hasRemaining()) {
            DataFrame dataFrame = new DataFrame(bytes);
            if (dataFrame.getType() == null) continue;
            this.incoming.offer(dataFrame);
            this.onMessage();
        }
    }

    protected abstract void unframe() throws IOException;

    protected abstract void write(byte[] var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        STARTING,
        CONNECTING,
        WAITING_ON_HANDSHAKE,
        READY,
        CLOSED;

    }
}

