/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.embedded.Port;
import org.glassfish.kernel.embedded.PortsImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@Scoped(value=PerLookup.class)
public class PortImpl
implements Port {
    @Inject
    CommandRunner runner = null;
    @Inject(name="plain")
    ActionReport report = null;
    @Inject
    PortsImpl ports;
    @Inject
    NetworkConfig config;
    @Inject
    HttpService httpService;
    String listenerName;
    int number;
    String defaultVirtualServer = "server";

    public void bind(final int portNumber) {
        this.number = portNumber;
        this.listenerName = this.getListenerName();
        try {
            ConfigSupport.apply(new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws TransactionFailure, PropertyVetoException {
                    Protocols protocols = (Protocols)params[0];
                    Protocol protocol = (Protocol)protocols.createChild(Protocol.class);
                    protocol.setName(PortImpl.this.listenerName);
                    protocols.getProtocol().add(protocol);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setDefaultVirtualServer(PortImpl.this.defaultVirtualServer);
                    protocol.setHttp(http);
                    NetworkListeners listeners = (NetworkListeners)params[1];
                    Transports transports = (Transports)params[2];
                    NetworkListener listener = (NetworkListener)listeners.createChild(NetworkListener.class);
                    listener.setName(PortImpl.this.listenerName);
                    listener.setPort(Integer.toString(portNumber));
                    listener.setProtocol(PortImpl.this.listenerName);
                    listener.setThreadPool("http-thread-pool");
                    if (listener.findThreadPool() == null) {
                        ThreadPool pool = (ThreadPool)listeners.createChild(ThreadPool.class);
                        pool.setName(PortImpl.this.listenerName);
                        listener.setThreadPool(PortImpl.this.listenerName);
                    }
                    listener.setTransport("tcp");
                    if (listener.findTransport() == null) {
                        Transport transport = (Transport)transports.createChild(Transport.class);
                        transport.setName(PortImpl.this.listenerName);
                        listener.setTransport(PortImpl.this.listenerName);
                    }
                    listeners.getNetworkListener().add(listener);
                    VirtualServer readOnlyVS = PortImpl.this.httpService.getVirtualServerByName(PortImpl.this.defaultVirtualServer);
                    ConfigSupport configSupport = new ConfigSupport();
                    Transaction t = configSupport.getTransaction(protocols);
                    VirtualServer vs = configSupport.enrollInTransaction(t, readOnlyVS);
                    vs.addNetworkListener(PortImpl.this.listenerName);
                    return listener;
                }
            }, new ConfigBeanProxy[]{this.config.getProtocols(), this.config.getNetworkListeners(), this.config.getTransports()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getListenerName() {
        int i = 1;
        String name = "embedded-listener";
        while (this.existsListener(name)) {
            name = "embedded-listener-" + i++;
        }
        return name;
    }

    private boolean existsListener(String lName) {
        for (NetworkListener nl : this.config.getNetworkListeners().getNetworkListener()) {
            if (!nl.getName().equals(lName)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        try {
            ConfigSupport.apply(new ConfigCode(){

                public Object run(ConfigBeanProxy[] params) throws PropertyVetoException, TransactionFailure {
                    NetworkListeners nt = (NetworkListeners)params[0];
                    VirtualServer vs = (VirtualServer)params[1];
                    Protocols protocols = (Protocols)params[2];
                    List protos = protocols.getProtocol();
                    for (Protocol proto : protos) {
                        if (!proto.getName().equals(PortImpl.this.listenerName)) continue;
                        protos.remove(proto);
                        break;
                    }
                    List list = nt.getNetworkListener();
                    for (NetworkListener listener : list) {
                        if (!listener.getName().equals(PortImpl.this.listenerName)) continue;
                        list.remove(listener);
                        break;
                    }
                    String regex = PortImpl.this.listenerName + ",?";
                    String lss = vs.getNetworkListeners();
                    vs.setNetworkListeners(lss.replaceAll(regex, ""));
                    return null;
                }
            }, new ConfigBeanProxy[]{this.config.getNetworkListeners(), this.httpService.getVirtualServerByName(this.defaultVirtualServer), this.config.getProtocols()});
        }
        catch (TransactionFailure tf) {
            tf.printStackTrace();
            throw new RuntimeException(tf);
        }
        this.ports.remove(this);
    }

    public int getPortNumber() {
        return this.number;
    }
}

