/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.InhabitantsDescriptor;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.common_impl.ByteArrayInhabitantsDescriptor;
import com.sun.enterprise.module.common_impl.Jar;
import com.sun.enterprise.module.common_impl.LogHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.Bundle;

public class OSGiModuleDefinition
implements ModuleDefinition,
Serializable {
    private String name;
    private String bundleName;
    private URI location;
    private String version;
    private SerializableManifest manifest;
    private String lifecyclePolicyClassName;
    private ModuleMetadata metadata = new ModuleMetadata();

    public OSGiModuleDefinition(File jar) throws IOException {
        this(Jar.create((File)jar), jar.toURI());
    }

    public OSGiModuleDefinition(Jar jarFile, URI location) throws IOException {
        this.location = location;
        this.manifest = new SerializableManifest(jarFile.getManifest());
        Attributes mainAttr = this.manifest.getMainAttributes();
        this.bundleName = this.manifest.getMainAttributes().getValue("Bundle-Name");
        this.name = mainAttr.getValue("Bundle-SymbolicName");
        if (this.name == null) {
            this.name = location.toString();
        }
        this.version = mainAttr.getValue("Bundle-Version");
        this.lifecyclePolicyClassName = mainAttr.getValue("HK2-Module-Lifecycle-Policy");
        jarFile.loadMetadata(this.metadata);
    }

    public OSGiModuleDefinition(Bundle b) throws IOException, URISyntaxException {
        this(new BundleJar(b), OSGiModuleDefinition.toURI(b));
    }

    static URI toURI(Bundle b) throws URISyntaxException {
        try {
            return new URI(b.getLocation());
        }
        catch (URISyntaxException ue) {
            if (b.getLocation().startsWith("initial@")) {
                return new URI(b.getLocation().substring("initial@".length()));
            }
            throw ue;
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getPublicInterfaces() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    public ModuleDependency[] getDependencies() {
        ArrayList<ModuleDependency> mds = new ArrayList<ModuleDependency>();
        String requiredBundles = this.getManifest().getMainAttributes().getValue("Require-Bundle");
        if (requiredBundles != null) {
            int i1;
            Logger.logger.log(Level.INFO, this.name + " -> " + requiredBundles);
            while ((i1 = requiredBundles.indexOf(34)) != -1) {
                int i2 = requiredBundles.indexOf(34, i1 + 1);
                StringBuilder sb = new StringBuilder();
                sb.append(requiredBundles.substring(0, i1));
                sb.append(requiredBundles.substring(i2 + 1));
                requiredBundles = sb.toString();
            }
            StringTokenizer st = new StringTokenizer(requiredBundles, ",", false);
            while (st.hasMoreTokens()) {
                String requireBundle = st.nextToken();
                int idx = requireBundle.indexOf(59);
                String requiredBundleName = idx == -1 ? requireBundle : requireBundle.substring(0, idx);
                mds.add(new ModuleDependency(requiredBundleName, null));
            }
        }
        return mds.toArray(new ModuleDependency[mds.size()]);
    }

    public URI[] getLocations() {
        return new URI[]{this.location};
    }

    public String getVersion() {
        return this.version;
    }

    public String getImportPolicyClassName() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    public String getLifecyclePolicyClassName() {
        return this.lifecyclePolicyClassName;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.name + "(" + this.bundleName + ")" + ':' + this.version;
    }

    private static class SerializableManifest
    extends Manifest
    implements Serializable {
        private SerializableManifest() {
        }

        private SerializableManifest(Manifest man) {
            super(man);
        }

        private Object writeReplace() throws ObjectStreamException {
            return new ManifestData(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ManifestData
        implements Serializable {
            private Map<String, String> mainAttributes = new HashMap<String, String>();
            private Map<String, Map<String, String>> entries;

            private ManifestData(Manifest manifest) {
                this.mainAttributes.putAll(this.toMap(manifest.getMainAttributes()));
                this.entries = new HashMap<String, Map<String, String>>();
                for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                    this.entries.put(entry.getKey(), this.toMap(entry.getValue()));
                }
            }

            private Object readResolve() throws ObjectStreamException {
                SerializableManifest m = new SerializableManifest();
                for (Map.Entry<String, String> entry : this.mainAttributes.entrySet()) {
                    m.getMainAttributes().putValue(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : this.entries.entrySet()) {
                    m.getEntries().put(entry.getKey(), this.toAttributes((Map)entry.getValue()));
                }
                return m;
            }

            private Attributes toAttributes(Map<String, String> map) {
                Attributes attrs = new Attributes();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    attrs.putValue(entry.getKey(), entry.getValue());
                }
                return attrs;
            }

            private Map<String, String> toMap(Attributes attrs) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : attrs.entrySet()) {
                    map.put(((Attributes.Name)Attributes.Name.class.cast(entry.getKey())).toString(), (String)entry.getValue());
                }
                return map;
            }
        }
    }

    private static class BundleJar
    extends Jar {
        private static final String SERVICE_LOCATION = "META-INF/services";
        Bundle b;
        Manifest m;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BundleJar(Bundle b) throws IOException {
            this.b = b;
            InputStream is = b.getEntry("META-INF/MANIFEST.MF").openStream();
            try {
                this.m = new Manifest(is);
            }
            finally {
                is.close();
            }
        }

        public Manifest getManifest() throws IOException {
            return this.m;
        }

        public void loadMetadata(ModuleMetadata result) {
            this.parseInhabitantsDescriptors(result);
            this.parseServiceDescriptors(result);
        }

        private void parseInhabitantsDescriptors(ModuleMetadata result) {
            URL url = this.b.getEntry("META-INF/inhabitants/default");
            if (url == null) {
                return;
            }
            try {
                result.addHabitat("default", (InhabitantsDescriptor)new ByteArrayInhabitantsDescriptor(url, this.loadFully(url)));
            }
            catch (IOException e) {
                LogHelper.getDefaultLogger().log(Level.SEVERE, "Error reading inhabitants list in " + this.b.getLocation(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseServiceDescriptors(ModuleMetadata result) {
            if (this.b.getEntry(SERVICE_LOCATION) == null) {
                return;
            }
            Enumeration entries = this.b.getEntryPaths(SERVICE_LOCATION);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    String serviceName = entry.substring(SERVICE_LOCATION.length() + 1);
                    InputStream is = null;
                    URL url = this.b.getEntry(entry);
                    try {
                        is = url.openStream();
                        result.load(url, serviceName, is);
                    }
                    catch (IOException e) {
                        LogHelper.getDefaultLogger().log(Level.SEVERE, "Error reading service provider in " + this.b.getLocation(), e);
                    }
                    finally {
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] loadFully(URL url) throws IOException {
            InputStream in = url.openStream();
            byte[] buf = new byte[]{};
            try {
                int count;
                int chunkSize = 512;
                byte[] chunk = new byte[chunkSize];
                while ((count = in.read(chunk, 0, chunkSize)) != -1) {
                    int curLength = buf.length;
                    byte[] newbuf = new byte[curLength + count];
                    System.arraycopy(buf, 0, newbuf, 0, curLength);
                    System.arraycopy(chunk, 0, newbuf, curLength, count);
                    buf = newbuf;
                }
                byte[] byArray = buf;
                return byArray;
            }
            finally {
                in.close();
            }
        }

        public String getBaseName() {
            throw new UnsupportedOperationException("Method not implemented");
        }
    }
}

