/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.config.ConfigAwareElement;
import com.sun.grizzly.config.ConfigProtocolFinderWrapper;
import com.sun.grizzly.config.ContainerStaticStreamAlgorithm;
import com.sun.grizzly.config.GrizzlyConfig;
import com.sun.grizzly.config.GrizzlyConfigException;
import com.sun.grizzly.config.Utils;
import com.sun.grizzly.config.WebProtocolHandler;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.PortUnification;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolChainInstanceHandler;
import com.sun.grizzly.config.dom.ProtocolFilter;
import com.sun.grizzly.config.dom.ProtocolFinder;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.HttpProtocolChain;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.portunif.CustomFilterChainProtocolHandler;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.PUReadFilter;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.websockets.WebSocketAsyncFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyEmbeddedHttp
extends SelectorThread {
    private final AtomicBoolean algorithmInitialized = new AtomicBoolean(false);
    private boolean isHttpSecured = false;
    protected static final ResourceBundle _rb = logger.getResourceBundle();
    private String defaultVirtualServer;
    protected PUReadFilter puFilter;
    protected final List<com.sun.grizzly.portunif.ProtocolFinder> finders = new ArrayList<com.sun.grizzly.portunif.ProtocolFinder>();
    protected final List<ProtocolHandler> handlers = new ArrayList<ProtocolHandler>();
    protected final List<PUPreProcessor> preprocessors = new ArrayList<PUPreProcessor>();

    public GrizzlyEmbeddedHttp() {
        this.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void initAlgorithm() {
        if (!this.algorithmInitialized.getAndSet(true)) {
            this.algorithmClass = ContainerStaticStreamAlgorithm.class;
            defaultAlgorithmInstalled = true;
        }
    }

    protected void initController() {
        this.controller = new Controller(){

            protected ExecutorService createKernelExecutor() {
                return this.createKernelExecutor("grizzly-kernel", "Grizzly-kernel-thread-" + GrizzlyEmbeddedHttp.this.port);
            }
        };
        super.initController();
        this.controller.setReadThreadsCount(this.readThreadsCount);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                GrizzlyEmbeddedHttp.this.stopEndpoint();
            }
        });
    }

    public void stopEndpoint() {
        try {
            super.stopEndpoint();
        }
        catch (Exception t) {
            logger.log(Level.SEVERE, "Unable to stop properly", t);
            try {
                if (this.selectorHandler != null && this.selectorHandler.getSelector() != null) {
                    this.selectorHandler.getSelector().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void configureProtocolChain() {
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){
            private final Queue<ProtocolChain> chains = DataStructures.getCLQinstance(ProtocolChain.class);

            public ProtocolChain poll() {
                ProtocolChain protocolChain = this.chains.poll();
                if (protocolChain == null) {
                    protocolChain = new HttpProtocolChain();
                    ((HttpProtocolChain)protocolChain).enableRCM(GrizzlyEmbeddedHttp.this.rcmSupport);
                    GrizzlyEmbeddedHttp.this.configureFilters(protocolChain);
                }
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return this.chains.offer(instance);
            }
        };
        this.controller.setProtocolChainInstanceHandler((com.sun.grizzly.ProtocolChainInstanceHandler)instanceHandler);
    }

    protected com.sun.grizzly.ProtocolFilter createReadFilter() {
        ReadFilter readFilter = new ReadFilter();
        readFilter.setContinuousExecution(Boolean.valueOf(System.getProperty("v3.grizzly.readFilter.continuousExecution", "false")).booleanValue());
        return readFilter;
    }

    public boolean isHttpSecured() {
        return this.isHttpSecured;
    }

    public void setHttpSecured(boolean httpSecured) {
        this.isHttpSecured = httpSecured;
    }

    public void configure(NetworkListener networkListener, Habitat habitat) {
        Transport transport = networkListener.findTransport();
        ThreadPool pool = networkListener.findThreadPool();
        this.setPort(Integer.parseInt(networkListener.getPort()));
        try {
            this.setAddress(InetAddress.getByName(networkListener.getAddress()));
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Invalid address for {0}: {1}", new Object[]{networkListener.getName(), networkListener.getAddress()});
        }
        this.configureTransport(transport);
        Protocol protocol = networkListener.findProtocol();
        boolean mayEnableAsync = !"admin-listener".equalsIgnoreCase(networkListener.getName());
        this.configureProtocol(networkListener, protocol, habitat, mayEnableAsync);
        this.configureThreadPool(networkListener, pool, networkListener.findHttpProtocol().getHttp());
    }

    protected void configureTransport(Transport transport) {
        String acceptorThreads = transport.getAcceptorThreads();
        try {
            int readController = Integer.parseInt(acceptorThreads) - 1;
            if (readController > 0) {
                this.setSelectorReadThreadsCount(readController);
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, transport.getName()});
        }
        this.setBufferSize(Integer.parseInt(transport.getBufferSizeBytes()));
        this.setSsBackLog(Integer.parseInt(transport.getMaxConnectionsCount()));
        this.setDisplayConfiguration(GrizzlyConfig.toBoolean(transport.getDisplayConfiguration()));
        this.setSelectorTimeout(Integer.parseInt(transport.getSelectorPollTimeoutMillis()));
        this.setTcpNoDelay(GrizzlyConfig.toBoolean(transport.getTcpNoDelay()));
        this.setLinger(Integer.parseInt(transport.getLinger()));
    }

    protected com.sun.grizzly.ProtocolChainInstanceHandler configureProtocol(NetworkListener networkListener, Protocol protocol, Habitat habitat, boolean mayEnableAsync) {
        if (protocol.getHttp() != null) {
            Http http = protocol.getHttp();
            this.configureHttpListenerProperty(http);
            this.configureKeepAlive(http);
            this.configureHttpProtocol(http);
            this.configureFileCache(http.getFileCache());
            this.defaultVirtualServer = http.getDefaultVirtualServer();
            if (mayEnableAsync && (GrizzlyConfig.toBoolean(http.getCometSupportEnabled()) || Boolean.getBoolean("v3.grizzly.cometSupport"))) {
                this.configureComet(habitat);
            }
            if (mayEnableAsync && GrizzlyConfig.toBoolean(http.getWebsocketsSupportEnabled())) {
                this.configureWebSockets(habitat);
            }
        } else if (protocol.getPortUnification() != null) {
            PortUnification pu = protocol.getPortUnification();
            String puFilterClassname = pu.getClassname();
            if (puFilterClassname != null) {
                try {
                    this.puFilter = (PUReadFilter)this.newInstance(puFilterClassname);
                    GrizzlyEmbeddedHttp.configureElement(this.puFilter, pu);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize port unification filter: " + puFilterClassname + " default filter will be used instead", e);
                }
            }
            List<ProtocolFinder> findersConfig = pu.getProtocolFinder();
            for (ProtocolFinder finderConfig : findersConfig) {
                String finderClassname = finderConfig.getClassname();
                try {
                    com.sun.grizzly.portunif.ProtocolFinder protocolFinder = (com.sun.grizzly.portunif.ProtocolFinder)this.newInstance(finderClassname);
                    GrizzlyEmbeddedHttp.configureElement(protocolFinder, finderConfig);
                    Protocol subProtocol = finderConfig.findProtocol();
                    com.sun.grizzly.ProtocolChainInstanceHandler protocolChain = this.configureProtocol(networkListener, subProtocol, habitat, mayEnableAsync);
                    String protocolName = subProtocol.getName();
                    this.finders.add(new ConfigProtocolFinderWrapper(protocolName, protocolFinder));
                    final String[] protocols = new String[]{protocolName};
                    if (protocolChain != null) {
                        this.handlers.add((ProtocolHandler)new CustomFilterChainProtocolHandler(protocolChain){

                            public String[] getProtocols() {
                                return protocols;
                            }

                            public ByteBuffer getByteBuffer() {
                                WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                                if (workerThread.getSSLEngine() != null) {
                                    return workerThread.getInputBB();
                                }
                                return null;
                            }
                        });
                        continue;
                    }
                    this.handlers.add((ProtocolHandler)new WebProtocolHandler(protocolName, GrizzlyConfig.toBoolean(pu.getWebProtocolStickyEnabled())));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize sub protocol. Finder: " + finderClassname, e);
                }
            }
            this.configurePortUnification();
        } else {
            ProtocolChainInstanceHandler pcihConfig = protocol.getProtocolChainInstanceHandler();
            if (pcihConfig == null) {
                logger.log(Level.WARNING, "Empty protocol declaration");
                return null;
            }
            ProtocolChain protocolChain = null;
            com.sun.grizzly.config.dom.ProtocolChain protocolChainConfig = pcihConfig.getProtocolChain();
            String protocolChainClassname = protocolChainConfig.getClassname();
            if (protocolChainClassname != null) {
                try {
                    protocolChain = (ProtocolChain)this.newInstance(protocolChainClassname);
                    GrizzlyEmbeddedHttp.configureElement(protocolChain, protocolChainConfig);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize protocol chain: " + protocolChainClassname + ". Default one will be used", e);
                }
            }
            if (protocolChain == null) {
                protocolChain = new DefaultProtocolChain();
            }
            for (ProtocolFilter protocolFilterConfig : protocolChainConfig.getProtocolFilter()) {
                String filterClassname = protocolFilterConfig.getClassname();
                try {
                    com.sun.grizzly.ProtocolFilter filter = (com.sun.grizzly.ProtocolFilter)this.newInstance(filterClassname);
                    GrizzlyEmbeddedHttp.configureElement(filter, protocolFilterConfig);
                    protocolChain.addFilter(filter);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize protocol filter: " + filterClassname, e);
                    throw new IllegalStateException("Can not initialize protocol filter: " + filterClassname);
                }
            }
            final ProtocolChain finalProtocolChain = protocolChain;
            return new DefaultProtocolChainInstanceHandler(){

                public boolean offer(ProtocolChain protocolChain) {
                    return true;
                }

                public ProtocolChain poll() {
                    return finalProtocolChain;
                }
            };
        }
        return null;
    }

    protected void configurePortUnification() {
        this.configurePortUnification(this.finders, this.handlers, this.preprocessors);
    }

    public void configurePortUnification(List<com.sun.grizzly.portunif.ProtocolFinder> protocolFinders, List<ProtocolHandler> protocolHandlers, List<PUPreProcessor> preProcessors) {
        if (this.puFilter != null) {
            this.puFilter.configure(protocolFinders, protocolHandlers, preProcessors);
        } else {
            super.configurePortUnification(protocolFinders, protocolHandlers, preProcessors);
        }
    }

    private void configureComet(Habitat habitat) {
        this.enableAsyncHandler(habitat, "comet", CometAsyncFilter.class);
    }

    private void configureWebSockets(Habitat habitat) {
        this.enableAsyncHandler(habitat, "websockets", WebSocketAsyncFilter.class);
    }

    private void enableAsyncHandler(Habitat habitat, String name, Class<? extends AsyncFilter> asyncFilterClass) {
        AsyncFilter filter = (AsyncFilter)habitat.getComponent(AsyncFilter.class, name);
        if (filter == null) {
            try {
                filter = asyncFilterClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new GrizzlyConfigException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new GrizzlyConfigException(e.getMessage(), e);
            }
        }
        this.setEnableAsyncExecution(true);
        if (this.getAsyncHandler() == null) {
            this.asyncHandler = new DefaultAsyncHandler();
            this.setAsyncHandler(this.asyncHandler);
        }
        this.getAsyncHandler().addAsyncFilter(filter);
    }

    private void configureFileCache(FileCache cache) {
        if (cache != null) {
            boolean enabled = GrizzlyConfig.toBoolean(cache.getEnabled());
            this.setFileCacheIsEnabled(enabled);
            this.setLargeFileCacheEnabled(enabled);
            this.setSecondsMaxAge(Integer.parseInt(cache.getMaxAgeSeconds()));
            this.setMaxCacheEntries(Integer.parseInt(cache.getMaxFilesCount()));
            this.setMaxLargeCacheSize(Integer.parseInt(cache.getMaxCacheSizeBytes()));
        }
    }

    private void configureHttpListenerProperty(Http http) throws NumberFormatException {
        try {
            this.setAdapter((Adapter)Class.forName(http.getAdapter()).newInstance());
        }
        catch (Exception e) {
            throw new GrizzlyConfigException(e.getMessage(), e);
        }
        this.setMaxKeepAliveRequests(Integer.parseInt(http.getMaxConnections()));
        this.setProperty("authPassthroughEnabled", GrizzlyConfig.toBoolean(http.getAuthPassThroughEnabled()));
        this.setMaxPostSize(Integer.parseInt(http.getMaxPostSizeBytes()));
        this.setCompression(http.getCompression());
        this.setCompressableMimeTypes(http.getCompressableMimeType());
        this.setSendBufferSize(Integer.parseInt(http.getSendBufferSizeBytes()));
        if (http.getNoCompressionUserAgents() != null) {
            this.setNoCompressionUserAgents(http.getNoCompressionUserAgents());
        }
        this.setCompressionMinSize(Integer.parseInt(http.getCompressionMinSizeBytes()));
        if (http.getRestrictedUserAgents() != null) {
            this.setRestrictedUserAgents(http.getRestrictedUserAgents());
        }
        this.enableRcmSupport(GrizzlyConfig.toBoolean(http.getRcmSupportEnabled()));
        this.setUploadTimeout(Integer.parseInt(http.getConnectionUploadTimeoutMillis()));
        this.setDisableUploadTimeout(!GrizzlyConfig.toBoolean(http.getUploadTimeoutEnabled()));
        this.setProperty("chunking-enabled", GrizzlyConfig.toBoolean(http.getChunkingEnabled()));
        this.setUseChunking(GrizzlyConfig.toBoolean(http.getChunkingEnabled()));
        this.setProperty("uriEncoding", http.getUriEncoding());
        if (http.getTraceEnabled() != null) {
            this.setProperty("traceEnabled", GrizzlyConfig.toBoolean(http.getTraceEnabled()));
        }
    }

    private void configureHttpProtocol(Http http) {
        if (http == null) {
            return;
        }
        this.setForcedRequestType(http.getForcedResponseType());
        this.setDefaultResponseType(http.getDefaultResponseType());
        String ct = http.getDefaultResponseType();
        if (this.getAdapter() instanceof StaticResourcesAdapter) {
            ((StaticResourcesAdapter)this.getAdapter()).setDefaultContentType(ct);
        }
        this.setMaxHttpHeaderSize(Integer.parseInt(http.getHeaderBufferLengthBytes()));
    }

    private void configureKeepAlive(Http http) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        if (http != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(http.getTimeoutSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, http.getTimeoutSeconds(), Integer.toString(timeoutInSeconds));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(http.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, http.getMaxConnections(), Integer.toString(maxConnections));
                logger.log(Level.WARNING, msg, ex);
            }
        }
        this.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        this.setMaxKeepAliveRequests(maxConnections);
    }

    private void configureThreadPool(NetworkListener networkListener, ThreadPool threadPool, Http http) {
        if (threadPool == null) {
            return;
        }
        try {
            int maxQueueSize = Integer.parseInt(threadPool.getMaxQueueSize());
            int minThreads = Integer.parseInt(threadPool.getMinThreadPoolSize());
            int maxThreads = Integer.parseInt(threadPool.getMaxThreadPoolSize());
            int keepAlive = Integer.parseInt(threadPool.getIdleThreadTimeoutSeconds());
            String name = Utils.composeThreadPoolName(networkListener);
            this.setThreadPool(this.newThreadPool(name, minThreads, maxThreads, maxQueueSize, keepAlive < 0 ? Long.MAX_VALUE : (long)(keepAlive * 1000), TimeUnit.MILLISECONDS));
            this.setCoreThreads(minThreads);
            this.setMaxThreads(maxThreads);
            int timeout = Integer.parseInt(http.getRequestTimeoutSeconds());
            if (!com.sun.grizzly.util.Utils.isDebugVM() && timeout > 0) {
                this.setTransactionTimeout(timeout * 1000);
            } else {
                this.setTransactionTimeout(-1);
            }
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, " Invalid thread-pool attribute", ex);
        }
    }

    protected ExtendedThreadPool newThreadPool(String name, int minThreads, int maxThreads, int maxQueueSize, long timeout, TimeUnit timeunit) {
        return new StatsThreadPool(name, minThreads, maxThreads, maxQueueSize, timeout, timeunit);
    }

    public String getDefaultVirtualServer() {
        return this.defaultVirtualServer;
    }

    protected Object newInstance(String classname) throws Exception {
        return Utils.newInstance(classname);
    }

    protected Class loadClass(String classname) throws ClassNotFoundException {
        return Utils.loadClass(classname);
    }

    private static void configureElement(Object instance, ConfigBeanProxy configuration) {
        if (instance instanceof ConfigAwareElement) {
            ((ConfigAwareElement)instance).configure(configuration);
        }
    }
}

