/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-domain")
@Async
@I18n(value="stop.domain.command")
@Cluster(value={RuntimeType.DAS})
public class StopDomainCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(StopDomainCommand.class);
    @Inject
    ModulesRegistry registry;
    @Inject
    ServerEnvironment env;
    @Param(optional=true, defaultValue="true")
    Boolean force;

    public void execute(AdminCommandContext context) {
        if (!this.env.isDas()) {
            String msg = localStrings.getLocalString("stop.domain.notDas", "stop-domain only works with domains, this is a {0}", new Object[]{this.env.getRuntimeType().toString()});
            context.getLogger().warning(msg);
            return;
        }
        context.getLogger().info(localStrings.getLocalString("stop.domain.init", "Server shutdown initiated"));
        Collection<Module> modules = this.registry.getModules("org.glassfish.core.glassfish");
        if (modules.size() == 1) {
            Module mgmtAgentModule = modules.iterator().next();
            mgmtAgentModule.stop();
        } else {
            context.getLogger().warning(modules.size() + " no of primordial modules found");
        }
        if (this.force.booleanValue()) {
            System.exit(0);
        }
    }
}

