/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicConfigListener
implements ConfigListener {
    private GrizzlyService grizzlyService;
    private Logger logger;
    private static final int RECONFIG_LOCK_TIMEOUT_SEC = 30;
    private static final ReentrantLock reconfigLock = new ReentrantLock();
    private static final Map<Integer, GrizzlyProxy.GrizzlyFuture> reconfigByPortLock = new HashMap<Integer, GrizzlyProxy.GrizzlyFuture>();

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unp = ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (DynamicConfigListener.this.logger.isLoggable(Level.FINE)) {
                    DynamicConfigListener.this.logger.log(Level.FINE, "NetworkConfig changed " + (Object)((Object)type) + " " + tClass + " " + t);
                }
                if (t instanceof NetworkListener) {
                    return DynamicConfigListener.this.processNetworkListener(type, (NetworkListener)t);
                }
                if (t instanceof Http) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)((Http)t).getParent());
                }
                if (t instanceof FileCache) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)((FileCache)t).getParent().getParent());
                }
                if (t instanceof Ssl) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)((Ssl)t).getParent());
                }
                if (t instanceof Protocol) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t);
                }
                if (t instanceof ThreadPool) {
                    ThreadPool pool = (ThreadPool)t;
                    NotProcessed notProcessed = null;
                    for (NetworkListener listener : pool.findNetworkListeners()) {
                        notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener);
                    }
                    return notProcessed;
                }
                if (t instanceof Transport) {
                    Transport transport = (Transport)t;
                    NotProcessed notProcessed = null;
                    for (NetworkListener listener : transport.findNetworkListeners()) {
                        notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener);
                    }
                    return notProcessed;
                }
                if (t instanceof VirtualServer && !DynamicConfigListener.this.grizzlyService.hasMapperUpdateListener()) {
                    return DynamicConfigListener.this.processVirtualServer(type, (VirtualServer)t);
                }
                return null;
            }
        }, this.logger);
        return unp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigBeanProxy> NotProcessed processNetworkListener(Changed.TYPE type, NetworkListener listener) {
        if (!"admin-listener".equals(listener.getName())) {
            int listenerPort = this.getPort(listener);
            Lock portLock = null;
            try {
                portLock = this.acquirePortLock(listener);
                if (type == Changed.TYPE.ADD) {
                    Future<Result<Thread>> future = this.grizzlyService.createNetworkProxy(listener);
                    future.get(30L, TimeUnit.SECONDS);
                    this.grizzlyService.registerNetworkProxy(listenerPort);
                } else if (type == Changed.TYPE.REMOVE) {
                    this.grizzlyService.removeNetworkProxy(listenerPort);
                } else if (type == Changed.TYPE.CHANGE) {
                    NetworkProxy proxy = this.grizzlyService.lookupNetworkProxy(listener);
                    boolean isRemovedOld = this.grizzlyService.removeNetworkProxy(proxy);
                    Future<Result<Thread>> future = this.grizzlyService.createNetworkProxy(listener);
                    if (future != null) {
                        future.get(30L, TimeUnit.SECONDS);
                        this.grizzlyService.registerNetworkProxy(listenerPort);
                    } else {
                        this.logger.log(Level.FINE, "Skipping proxy registration for the listener " + listener.getName());
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Network listener configuration error. Type: " + (Object)((Object)type), e);
            }
            finally {
                if (portLock != null) {
                    this.releaseListenerLock(portLock);
                }
            }
        }
        return null;
    }

    private NotProcessed processProtocol(Changed.TYPE type, Protocol protocol) {
        NotProcessed notProcessed = null;
        for (NetworkListener listener : protocol.findNetworkListeners()) {
            notProcessed = this.processNetworkListener(type, listener);
        }
        return notProcessed;
    }

    private NotProcessed processVirtualServer(Changed.TYPE type, VirtualServer vs) {
        NotProcessed notProcessed = null;
        String list = vs.getNetworkListeners();
        for (String s : GrizzlyProxy.toArray(list, ",")) {
            for (NetworkListener n : vs.findNetworkListeners()) {
                if (!n.getName().equals(s)) continue;
                notProcessed = this.processNetworkListener(type, n);
            }
        }
        return notProcessed;
    }

    public void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private Lock acquirePortLock(NetworkListener listener) throws InterruptedException, TimeoutException {
        boolean isLoggingFinest = this.logger.isLoggable(Level.FINEST);
        int port = this.getPort(listener);
        try {
            while (true) {
                NetworkProxy runningProxy;
                this.logger.finest("Aquire reconfig lock");
                if (!reconfigLock.tryLock(30L, TimeUnit.SECONDS)) break;
                Future lock = null;
                lock = reconfigByPortLock.get(port);
                if (isLoggingFinest) {
                    this.logger.finest("Reconfig lock for port: " + port + " is " + lock);
                }
                int proxyPort = -1;
                if (lock == null && (runningProxy = this.grizzlyService.lookupNetworkProxy(listener)) != null) {
                    proxyPort = runningProxy.getPort();
                    if (port != proxyPort) {
                        lock = reconfigByPortLock.get(proxyPort);
                        if (isLoggingFinest) {
                            this.logger.finest("Reconfig lock for proxyport: " + proxyPort + " is " + lock);
                        }
                    } else {
                        proxyPort = -1;
                    }
                }
                if (lock != null) {
                    reconfigLock.unlock();
                    try {
                        this.logger.finest("Waiting on reconfig lock");
                        lock.get(30L, TimeUnit.SECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    GrizzlyProxy.GrizzlyFuture future = new GrizzlyProxy.GrizzlyFuture();
                    if (isLoggingFinest) {
                        this.logger.finest("Set reconfig lock for ports: " + port + " and " + proxyPort + ": " + future);
                    }
                    reconfigByPortLock.put(port, future);
                    if (proxyPort != -1) {
                        reconfigByPortLock.put(proxyPort, future);
                    }
                    Lock lock2 = new Lock(port, proxyPort);
                    return lock2;
                }
            }
            throw new TimeoutException("Lock timeout");
        }
        finally {
            if (reconfigLock.isHeldByCurrentThread()) {
                reconfigLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseListenerLock(Lock lock) {
        boolean isLoggingFinest = this.logger.isLoggable(Level.FINEST);
        reconfigLock.lock();
        try {
            int[] ports = lock.getPorts();
            if (isLoggingFinest) {
                this.logger.finest("Release reconfig lock for ports: " + Arrays.toString(ports));
            }
            GrizzlyProxy.GrizzlyFuture future = null;
            for (int port : ports) {
                if (port == -1) continue;
                future = reconfigByPortLock.remove(port);
            }
            if (future != null) {
                if (isLoggingFinest) {
                    this.logger.finest("Release reconfig lock, set result: " + future);
                }
                future.setResult((Result<Thread>)new Result((Object)Thread.currentThread()));
            }
        }
        finally {
            reconfigLock.unlock();
        }
    }

    private int getPort(NetworkListener listener) {
        int listenerPort = -1;
        try {
            listenerPort = Integer.parseInt(listener.getPort());
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.WARNING, "Can not parse network-listener port number: " + listener.getPort());
        }
        return listenerPort;
    }

    private static final class Lock {
        private final int[] ports;

        public Lock(int ... ports) {
            this.ports = ports;
        }

        public int[] getPorts() {
            return this.ports;
        }
    }
}

