/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.StateCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable")
@I18n(value="enable.command")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
public class EnableCommand
extends StateCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    VersioningService versioningService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(AdminCommandContext context) {
        block28: {
            ReadableArchive archive;
            ActionReport report = context.getActionReport();
            Logger logger = context.getLogger();
            boolean doReplication = false;
            if (Utility.getEnvOrProp((String)"ENABLE_REPLICATION") != null) {
                doReplication = Boolean.parseBoolean(Utility.getEnvOrProp((String)"ENABLE_REPLICATION"));
            }
            if (!doReplication) {
                if (!this.deployment.isRegistered(this.name())) {
                    report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                try {
                    this.versioningService.handleDisable(this.name(), this.target, report);
                }
                catch (VersioningSyntaxException e) {
                    report.failure(logger, e.getMessage());
                    return;
                }
            }
            if (this.domain.isAppRefEnabledInTarget(this.name(), this.target)) {
                logger.fine("The application is already enabled");
                return;
            }
            if (!this.domain.isCurrentInstanceMatchingTarget(this.target, this.server.getName())) {
                try {
                    this.deployment.updateAppEnabledAttributeInDomainXML(this.name(), this.target, true);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to set enable attribute for " + this.name());
                }
                return;
            }
            File file = null;
            ApplicationRef appRef = null;
            DeployCommandParameters commandParams = null;
            Properties contextProps = new Properties();
            Map modulePropsMap = null;
            ApplicationConfigInfo savedAppConfig = null;
            try {
                Application app = null;
                for (ApplicationName module : this.applications.getModules()) {
                    if (!module.getName().equals(this.name())) continue;
                    app = (Application)module;
                    break;
                }
                for (ApplicationRef ref : this.server.getApplicationRef()) {
                    if (!ref.getRef().equals(this.name())) continue;
                    appRef = ref;
                    break;
                }
                if (app != null) {
                    commandParams = app.getDeployParameters(appRef);
                    commandParams.origin = OpsParams.Origin.load;
                    commandParams.target = this.target;
                    contextProps = app.getDeployProperties();
                    modulePropsMap = app.getModulePropertiesMap();
                    savedAppConfig = new ApplicationConfigInfo(app);
                }
                if (commandParams == null) {
                    report.setMessage(localStrings.getLocalString("bug", "invalid domain.xml entries, please file a bug"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                URI uri = new URI(app.getLocation());
                file = new File(uri);
                if (!file.exists()) {
                    report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                archive = this.archiveFactory.openArchive(file);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                report.setMessage(localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(archive).build();
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)contextProps);
            savedAppConfig.store(appProps);
            if (modulePropsMap != null) {
                deploymentContext.setModulePropsMap(modulePropsMap);
            }
            this.deployment.deploy(deploymentContext);
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                try {
                    this.deployment.updateAppEnabledAttributeInDomainXML(this.name(), this.target, true);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to set enable attribute for " + this.name());
                }
            }
            Object var16_20 = null;
            try {
                archive.close();
            }
            catch (IOException e2) {
                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e2);
            }
            break block28;
            {
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error during enabling: ", e);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(e.getMessage());
                    Object var16_21 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                try {
                    archive.close();
                }
                catch (IOException e2) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e2);
                }
                throw throwable;
            }
        }
    }
}

