/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="postdeploy")
@Supplemental(value="deploy")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class PostDeployCommand
extends DeployCommandParameters
implements AdminCommand {
    private final Collection<String> excludedDeployCommandParamNames = this.initExcludedDeployCommandParamNames();
    @Inject
    private ClusterExecutor clusterExecutor;

    public void execute(AdminCommandContext context) {
        ParameterMap paramMap;
        DeployCommandSupplementalInfo suppInfo = (DeployCommandSupplementalInfo)context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        DeploymentContext dc = suppInfo.deploymentContext();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        ParameterMapExtractor extractor = new ParameterMapExtractor((AdminCommand)this);
        try {
            paramMap = extractor.extract(this.excludedDeployCommandParamNames);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        File genPolicyDir = dc.getScratchDir("policy");
        if (genPolicyDir.isDirectory()) {
            paramMap.set((Object)"generatedpolicydir", (Object)dc.getScratchDir("policy").getAbsolutePath());
        }
        paramMap.set((Object)"generatedxmldir", (Object)dc.getScratchDir("xml").getAbsolutePath());
        paramMap.set((Object)"generatedejbdir", (Object)dc.getScratchDir("ejb").getAbsolutePath());
        paramMap.set((Object)"generatedjspdir", (Object)dc.getScratchDir("jsp").getAbsolutePath());
        paramMap.set((Object)"DEFAULT", (Object)suppInfo.archiveFile().getAbsolutePath());
        File actualPlan = suppInfo.deploymentPlan();
        if (actualPlan != null) {
            paramMap.set((Object)"deploymentplan", (Object)actualPlan.getAbsolutePath());
        }
        paramMap.set((Object)"upload", (Object)"true");
        paramMap.set((Object)"name", (Object)params.name);
        if (params.previousContextRoot != null) {
            paramMap.set((Object)"preservedcontextroot", (Object)params.previousContextRoot);
        }
        paramMap.set((Object)"virtualservers", (Object)params.virtualservers);
        paramMap.set((Object)"libraries", (Object)params.libraries);
        Properties appProps = dc.getAppProps();
        appProps.remove("appConfig");
        paramMap.set((Object)"appprops", (Object)extractor.propertiesValue(appProps, ':'));
        this.clusterExecutor.execute("_deploy", (AdminCommand)this, context, paramMap);
    }

    private Collection<String> initExcludedDeployCommandParamNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("path");
        result.add("deploymentplan");
        result.add("upload");
        return result;
    }
}

