/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.versioning;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@I18n(value="versioning.service")
@Service
@Scoped(value=PerLookup.class)
public class VersioningService {
    private static final LocalStringManagerImpl LOCALSTRINGS = new LocalStringManagerImpl(VersioningService.class);
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Domain domain;
    static final String REPOSITORY_DASH = "-";
    public static final String EXPRESSION_SEPARATOR = ":";
    public static final String EXPRESSION_WILDCARD = "*";

    public final String getUntaggedName(String appName) throws VersioningSyntaxException {
        int semiColonIndex = appName.indexOf(EXPRESSION_SEPARATOR);
        if (semiColonIndex != -1) {
            if (semiColonIndex == appName.length() - 1) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("invalid.appname", "excepted version identifier after semi-colon: {0}", new Object[]{appName}));
            }
            return appName.substring(0, semiColonIndex);
        }
        return appName;
    }

    public final String getExpression(String appName) throws VersioningSyntaxException {
        int semiColonIndex = appName.indexOf(EXPRESSION_SEPARATOR);
        if (semiColonIndex != -1) {
            if (semiColonIndex != appName.lastIndexOf(EXPRESSION_SEPARATOR)) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("invalid.expression", "semi-colon cannot be used twice in version expression/identifier: {0}", new Object[]{appName}));
            }
            if (semiColonIndex == appName.length() - 1) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("invalid.appName", "excepted version expression/identifier after semi-colon: {0}", new Object[]{appName}));
            }
            return appName.substring(semiColonIndex + 1, appName.length());
        }
        return null;
    }

    public List<String> getVersions(String untaggedName, List<ApplicationRef> allApplicationRefs) {
        ArrayList<String> allVersions = new ArrayList<String>();
        for (ApplicationRef ref : allApplicationRefs) {
            if (!ref.getRef().startsWith(untaggedName + EXPRESSION_SEPARATOR) && !ref.getRef().equals(untaggedName)) continue;
            allVersions.add(ref.getRef());
        }
        return allVersions;
    }

    public List<String> getAllversions(String untaggedName, String target) {
        List allApplicationRefs = this.domain.getApplicationRefsInTarget(target);
        return this.getVersions(untaggedName, allApplicationRefs);
    }

    public final String getEnabledVersion(String name, String target) throws VersioningSyntaxException {
        String untaggedName = this.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untaggedName, target);
        if (allVersions != null) {
            for (String app : allVersions) {
                ApplicationRef ref = this.domain.getApplicationRefInTarget(app, target);
                if (ref == null || !Boolean.valueOf(ref.getEnabled()).booleanValue()) continue;
                return app;
            }
        }
        return null;
    }

    public final List<String> matchExpression(List<String> listVersion, String appName) throws VersioningException {
        if (listVersion.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        String expressionVersion = this.getExpression(appName);
        ArrayList<String> matchedVersions = new ArrayList<String>(listVersion);
        if (expressionVersion == null) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningException(LOCALSTRINGS.getLocalString("version.notreg", "version {0} not registered", new Object[]{appName}));
        }
        if (expressionVersion.indexOf(EXPRESSION_WILDCARD) == -1) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningException(LOCALSTRINGS.getLocalString("version.notreg", "Version {0} not registered", new Object[]{appName}));
        }
        StringTokenizer st = new StringTokenizer(expressionVersion, EXPRESSION_WILDCARD);
        String lastToken = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            for (String app : new ArrayList<String>(matchedVersions)) {
                String expression = this.getExpression(app);
                int tokenCursor = 0;
                if (lastToken != null) {
                    tokenCursor = expression.indexOf(lastToken) + 1;
                }
                if (expression != null && expression.indexOf(token, tokenCursor) != -1) continue;
                matchedVersions.remove(app);
            }
            lastToken = token;
        }
        return matchedVersions;
    }

    public final List<String> getMatchedVersions(String name, String target) throws VersioningException {
        String untagged = this.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untagged, target);
        if (allVersions.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return this.matchExpression(allVersions, name);
    }

    public final String getRepositoryName(String appName) throws VersioningSyntaxException {
        String expression = this.getExpression(appName);
        String untaggedName = this.getUntaggedName(appName);
        if (expression != null) {
            StringBuilder repositoryNameBuilder = new StringBuilder(untaggedName);
            repositoryNameBuilder.append(REPOSITORY_DASH);
            repositoryNameBuilder.append(expression);
            return repositoryNameBuilder.toString();
        }
        return untaggedName;
    }

    public void handleDisable(String appName, String target, ActionReport report) throws VersioningSyntaxException {
        String enabledVersion = this.getEnabledVersion(appName, target);
        if (enabledVersion != null && !enabledVersion.equals(appName)) {
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)enabledVersion);
            parameters.add((Object)"target", (Object)target);
            ActionReport subReport = report.addSubActionsReport();
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", subReport);
            inv.parameters(parameters).execute();
        }
    }
}

