/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand,
EventListener {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    private static final String COPY_IN_PLACE_ARCHIVE_PROP_NAME = "copy.inplace.archive";
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";
    @Inject
    Applications apps;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;
    @Inject
    DownloadableArtifacts downloadableArtifacts;
    @Inject
    Events events;
    @Inject
    VersioningService versioningService;
    private File safeCopyOfApp = null;
    private File safeCopyOfDeploymentPlan = null;
    private File originalPathValue;

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        block56: {
            block57: {
                block54: {
                    block53: {
                        this.events.register((EventListener)this);
                        suppInfo = new DeployCommandSupplementalInfo();
                        context.getActionReport().setResultType(DeployCommandSupplementalInfo.class, (Object)suppInfo);
                        try {
                            block62: {
                                block58: {
                                    block60: {
                                        operationStartTime = Calendar.getInstance().getTimeInMillis();
                                        report = context.getActionReport();
                                        logger = context.getLogger();
                                        this.originalPathValue = this.path;
                                        if (!this.path.exists()) {
                                            report.setMessage(DeployCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{this.path.getAbsolutePath()}));
                                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                            var26_6 = null;
                                            break block53;
                                        }
                                        if (this.snifferManager.hasNoSniffers()) {
                                            msg = DeployCommand.localStrings.getLocalString("nocontainer", "No container services registered, done...");
                                            report.failure(logger, msg);
                                            break block54;
                                        }
                                        try {
                                            archive = this.archiveFactory.openArchive(this.path, (DeployCommandParameters)this);
                                        }
                                        catch (IOException e) {
                                            msg = DeployCommand.localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", new Object[]{this.path.getAbsolutePath()});
                                            if (this.logReportedErrors.booleanValue()) {
                                                report.failure(logger, msg, (Throwable)e);
                                            } else {
                                                report.setMessage(msg + this.path.getAbsolutePath() + e.toString());
                                                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                            }
                                            var26_8 = null;
                                            this.events.unregister((EventListener)this);
                                            return;
                                        }
                                        expansionDir = null;
                                        try {
                                            archiveHandler = this.deployment.getArchiveHandler(archive);
                                            if (archiveHandler == null) {
                                                report.failure(logger, DeployCommand.localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{this.path.getName()}));
                                                var23_20 = null;
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        catch (Throwable e) {
                                            logger.log(Level.SEVERE, e.getMessage(), e);
                                            report.failure(logger, DeployCommand.localStrings.getLocalString("errDuringDepl", "Error during deployment : ") + e.getMessage(), null);
                                            var23_23 = null;
                                            try {
                                                archive.close();
                                            }
                                            catch (IOException e) {
                                                logger.log(Level.INFO, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                                            }
                                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                if (report.hasWarnings()) {
                                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.successwithwarning", "Application deployed successfully with name {0} and with the following warning(s):", new Object[]{this.name}));
                                                } else {
                                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed successfully with name {0}", new Object[]{this.name}));
                                                }
                                                logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                                                break block56;
                                            }
                                            if (expansionDir != null) {
                                                FileUtils.whack(expansionDir);
                                            }
                                            break block56;
                                        }
                                        catch (Throwable var22_43) {
                                            block59: {
                                                var23_24 = null;
                                                ** try [egrp 8[TRYBLOCK] [11 : 998->1008)] { 
lbl70:
                                                // 1 sources

                                                archive.close();
                                                break block59;
lbl72:
                                                // 1 sources

                                                catch (IOException e) {
                                                    logger.log(Level.INFO, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                                                }
                                            }
                                            if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                if (expansionDir == null) throw var22_43;
                                                FileUtils.whack(expansionDir);
                                                throw var22_43;
                                            }
                                            if (report.hasWarnings()) {
                                                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.successwithwarning", "Application deployed successfully with name {0} and with the following warning(s):", new Object[]{this.name}));
                                            } else {
                                                report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed successfully with name {0}", new Object[]{this.name}));
                                            }
                                            logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                                            throw var22_43;
                                        }
                                        ** try [egrp 8[TRYBLOCK] [11 : 998->1008)] { 
lbl87:
                                        // 1 sources

                                        archive.close();
                                        break block60;
lbl89:
                                        // 1 sources

                                        catch (IOException e) {
                                            logger.log(Level.INFO, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                                        }
                                    }
                                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                        if (report.hasWarnings()) {
                                            report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.successwithwarning", "Application deployed successfully with name {0} and with the following warning(s):", new Object[]{this.name}));
                                        } else {
                                            report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed successfully with name {0}", new Object[]{this.name}));
                                        }
                                        logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                                        break block57;
                                    }
                                    if (expansionDir == null) break block57;
                                    FileUtils.whack(expansionDir);
                                    break block57;
lbl-1000:
                                    // 1 sources

                                    {
                                        initialContext = new DeploymentContextImpl(report, logger, archive, (OpsParams)this, (ServerEnvironment)this.env);
                                        if (this.name == null) {
                                            this.name = archiveHandler.getDefaultApplicationName(archive, (DeploymentContext)initialContext);
                                        }
                                        if (!this.enabled.booleanValue()) ** GOTO lbl-1000
                                        try {
                                            this.versioningService.handleDisable(this.name, this.target, report);
                                        }
                                        catch (VersioningSyntaxException e) {
                                            block61: {
                                                report.failure(logger, e.getMessage());
                                                var23_21 = null;
                                                ** try [egrp 8[TRYBLOCK] [11 : 998->1008)] { 
lbl116:
                                                // 1 sources

                                                archive.close();
                                                break block61;
lbl118:
                                                // 1 sources

                                                catch (IOException e) {
                                                    logger.log(Level.INFO, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                                                }
                                            }
                                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                if (report.hasWarnings()) {
                                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.successwithwarning", "Application deployed successfully with name {0} and with the following warning(s):", new Object[]{this.name}));
                                                } else {
                                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed successfully with name {0}", new Object[]{this.name}));
                                                }
                                                logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                                            } else if (expansionDir != null) {
                                                FileUtils.whack(expansionDir);
                                            }
                                            var26_10 = null;
                                            this.events.unregister((EventListener)this);
                                            return;
                                        }
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        part = report.getTopMessagePart();
                                        part.addProperty("name", this.name);
                                        savedAppConfig = new ApplicationConfigInfo((com.sun.enterprise.config.serverbeans.Application)this.apps.getModule(com.sun.enterprise.config.serverbeans.Application.class, this.name));
                                        undeployProps = this.handleRedeploy(this.name, report);
                                        if (!this.keepreposdir.booleanValue()) {
                                            FileUtils.whack((File)new File(this.env.getApplicationRepositoryPath(), this.name));
                                        }
                                        source = new File(archive.getURI().getSchemeSpecificPart());
                                        isDirectoryDeployed = true;
                                        if (!source.isDirectory()) {
                                            isDirectoryDeployed = false;
                                            this.path = expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                                        }
                                        deploymentContext = this.deployment.getBuilder(logger, (OpsParams)this, report).source(archive).archiveHandler(archiveHandler).build((ExtendedDeploymentContext)initialContext);
                                        if (undeployProps != null) {
                                            deploymentContext.getAppProps().putAll((Map<?, ?>)undeployProps);
                                        }
                                        if (this.properties != null) {
                                            deploymentContext.getAppProps().putAll((Map<?, ?>)this.properties);
                                        }
                                        if (this.property != null) {
                                            deploymentContext.getAppProps().putAll((Map<?, ?>)this.property);
                                        }
                                        deploymentContext.clean();
                                        appProps = deploymentContext.getAppProps();
                                        appLocation = this.relativizeWithinDomainIfPossible(deploymentContext.getSource().getURI());
                                        appProps.setProperty("location", appLocation);
                                        appProps.setProperty("object-type", "user");
                                        if (this.contextroot != null) {
                                            appProps.setProperty("context-root", this.contextroot);
                                        }
                                        appProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                                        savedAppConfig.store(appProps);
                                        t = this.deployment.prepareAppConfigChanges((DeploymentContext)deploymentContext);
                                        appInfo = this.type == null ? this.deployment.deploy(deploymentContext) : this.deployment.deploy((Collection)this.deployment.prepareSniffersForOSGiDeployment(this.type, (DeploymentContext)deploymentContext), deploymentContext);
                                        if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                                            try {
                                                this.moveAppFilesToPermanentLocation(deploymentContext, logger);
                                                this.recordFileLocations(appProps);
                                                this.prepareParametersForSupplementalCommand(suppInfo, (DeploymentContext)deploymentContext);
                                                this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext, t);
                                            }
                                            catch (Exception e) {
                                                this.deployment.undeploy(this.name, deploymentContext);
                                                deploymentContext.clean();
                                                throw e;
                                            }
                                        }
                                        if (this.retrieve == null) break block58;
                                        DeployCommand.retrieveArtifacts(context, this.name, this.retrieve, this.downloadableArtifacts, false);
                                    }
                                }
                                var23_22 = null;
                                ** try [egrp 8[TRYBLOCK] [11 : 998->1008)] { 
lbl187:
                                // 1 sources

                                archive.close();
                                break block62;
lbl189:
                                // 1 sources

                                catch (IOException e) {
                                    logger.log(Level.INFO, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                                }
                            }
                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                if (report.hasWarnings()) {
                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.successwithwarning", "Application deployed successfully with name {0} and with the following warning(s):", new Object[]{this.name}));
                                } else {
                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed successfully with name {0}", new Object[]{this.name}));
                                }
                                logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                                break block56;
                            }
                            if (expansionDir != null) {
                                FileUtils.whack((File)expansionDir);
                            }
                            break block56;
                        }
                        catch (Throwable var25_44) {
                            var26_12 = null;
                            this.events.unregister((EventListener)this);
                            throw var25_44;
                        }
                    }
                    this.events.unregister((EventListener)this);
                    return;
                }
                var26_7 = null;
                this.events.unregister((EventListener)this);
                return;
            }
            var26_9 = null;
            this.events.unregister((EventListener)this);
            return;
        }
        var26_11 = null;
        this.events.unregister((EventListener)this);
    }

    private String relativizeWithinDomainIfPossible(URI absURI) throws URISyntaxException {
        URI instanceRootURI = new URI(System.getProperty(INSTANCE_ROOT_URI_PROPERTY_NAME));
        URI appURI = instanceRootURI.relativize(absURI);
        String appLocation = appURI.isAbsolute() ? appURI.toString() : "${com.sun.aas.instanceRootURI}/" + appURI.toString();
        return appLocation;
    }

    private void moveAppFilesToPermanentLocation(ExtendedDeploymentContext deploymentContext, Logger logger) throws IOException {
        File finalUploadDir = deploymentContext.getAppInternalDir();
        finalUploadDir.mkdirs();
        this.safeCopyOfApp = this.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.originalPathValue, logger);
        this.safeCopyOfDeploymentPlan = this.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.deploymentplan, logger);
    }

    private File renameUploadedFileOrCopyInPlaceFile(File finalUploadDir, File fileParam, Logger logger) throws IOException {
        if (fileParam == null) {
            return null;
        }
        File appsDir = this.env.getApplicationRepositoryPath();
        File result = fileParam;
        if (!appsDir.toURI().relativize(fileParam.toURI()).isAbsolute()) {
            result = new File(finalUploadDir, fileParam.getName());
            FileUtils.renameFile((File)fileParam, (File)result);
            result.setLastModified(fileParam.lastModified());
        } else {
            boolean copyInPlaceArchive = Boolean.valueOf(System.getProperty(COPY_IN_PLACE_ARCHIVE_PROP_NAME, "true"));
            if (!fileParam.isDirectory() && copyInPlaceArchive) {
                long startTime = System.currentTimeMillis();
                result = new File(finalUploadDir, fileParam.getName());
                FileUtils.copy((File)fileParam, (File)result);
                result.setLastModified(fileParam.lastModified());
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("*** In-place archive copy of " + fileParam.getAbsolutePath() + " took " + (System.currentTimeMillis() - startTime) + " ms");
                }
            }
        }
        return result;
    }

    private void prepareParametersForSupplementalCommand(DeployCommandSupplementalInfo suppInfo, DeploymentContext dc) {
        if (this.safeCopyOfApp != null) {
            suppInfo.setArchiveFile(this.safeCopyOfApp);
        }
        if (this.safeCopyOfDeploymentPlan != null) {
            suppInfo.setDeploymentPlan(this.safeCopyOfDeploymentPlan);
        }
        suppInfo.setDeploymentContext(dc);
    }

    private void recordFileLocations(Properties appProps) throws URISyntaxException {
        if (this.safeCopyOfApp != null) {
            appProps.setProperty("appLocation", this.relativizeWithinDomainIfPossible(this.safeCopyOfApp.toURI()));
        }
        if (this.safeCopyOfDeploymentPlan != null) {
            appProps.setProperty("deploymentPlanLocation", this.relativizeWithinDomainIfPossible(this.safeCopyOfDeploymentPlan.toURI()));
        }
    }

    private Properties handleRedeploy(String name, ActionReport report) throws Exception {
        boolean isRegistered = this.deployment.isRegistered(name);
        if (isRegistered && !this.force.booleanValue()) {
            String msg = localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name});
            throw new Exception(msg);
        }
        if (isRegistered && this.force.booleanValue()) {
            Properties undeployProperties;
            com.sun.enterprise.config.serverbeans.Application app = (com.sun.enterprise.config.serverbeans.Application)this.apps.getModule(com.sun.enterprise.config.serverbeans.Application.class, name);
            this.settingsFromDomainXML(app);
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)name);
            parameters.add((Object)"target", (Object)this.target);
            parameters.add((Object)"keepreposdir", (Object)this.keepreposdir.toString());
            if (this.dropandcreatetables != null) {
                parameters.add((Object)"droptables", (Object)this.dropandcreatetables.toString());
            }
            parameters.add((Object)"ignoreCascade", (Object)this.force.toString());
            ActionReport subReport = report.addSubActionsReport();
            subReport.setExtraProperties(new Properties());
            if (this.properties != null && this.properties.containsKey("keepSessions")) {
                undeployProperties = new Properties();
                undeployProperties.put("keepSessions", this.properties.getProperty("keepSessions"));
                parameters.add((Object)"properties", (Object)this.propertiesValue(undeployProperties, ':'));
            } else if (this.property != null && this.property.containsKey("keepSessions")) {
                undeployProperties = new Properties();
                undeployProperties.put("keepSessions", this.properties.getProperty("keepSessions"));
                parameters.add((Object)"properties", (Object)this.propertiesValue(undeployProperties, ':'));
            }
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", subReport);
            inv.parameters(parameters).execute();
            return subReport.getExtraProperties();
        }
        return null;
    }

    public static void retrieveArtifacts(AdminCommandContext context, String appName, String targetLocalDir, DownloadableArtifacts downloadableArtifacts) {
        DeployCommand.retrieveArtifacts(context, appName, targetLocalDir, downloadableArtifacts, true);
    }

    public static void retrieveArtifacts(AdminCommandContext context, String appName, String targetLocalDir, DownloadableArtifacts downloadableArtifacts, boolean reportErrorsInTopReport) {
        Logger logger = context.getLogger();
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            Properties props = new Properties();
            props.setProperty("file-xfer-root", targetLocalDir.replace('\\', '/'));
            for (DownloadableArtifacts.FullAndPartURIs uriPair : downloadableArtifacts.getArtifacts(appName)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "About to download artifact " + uriPair.getFull());
                }
                outboundPayload.attachFile("application/octet-stream", uriPair.getPart(), "files", props, new File(uriPair.getFull().getSchemeSpecificPart()));
            }
        }
        catch (Exception e) {
            String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
            logger.log(Level.SEVERE, errorMsg, e);
            ActionReport report = context.getActionReport();
            if (!reportErrorsInTopReport) {
                report = report.addSubActionsReport();
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
        }
    }

    private void settingsFromDomainXML(com.sun.enterprise.config.serverbeans.Application app) {
        if (this.name != null) {
            String compatProp;
            if (this.contextroot == null && app.getContextRoot() != null) {
                this.previousContextRoot = app.getContextRoot();
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            if (this.virtualservers == null) {
                this.virtualservers = ConfigBeansUtilities.getVirtualServers((String)this.target, (String)this.name);
            }
            if ((compatProp = app.getDeployProperties().getProperty("compatibility")) != null) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                if (this.properties.getProperty("compatibility") == null) {
                    this.properties.setProperty("compatibility", compatProp);
                }
            }
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            DeploymentContext context = (DeploymentContext)event.hook();
            if (this.verify.booleanValue()) {
                if (!this.isVerifierInstalled()) {
                    context.getLogger().warning("Verifier is not installed yet. Install verifier module.");
                } else {
                    this.invokeVerifier(context);
                }
            }
        }
    }

    private void invokeVerifier(DeploymentContext context) throws DeploymentException {
        Verifier verifier = this.habitat.getComponent(Verifier.class);
        VerifierFrameworkContext verifierFrameworkContext = new VerifierFrameworkContext();
        verifierFrameworkContext.setArchive((Archive)context.getSource());
        verifierFrameworkContext.setApplication((Application)context.getModuleMetaData(Application.class));
        verifierFrameworkContext.setJarFileName(context.getSourceDir().getAbsolutePath());
        verifierFrameworkContext.setJspOutDir(context.getScratchDir("jsp"));
        verifierFrameworkContext.setOutputDirName(this.env.getDomainRoot().getAbsolutePath() + "/logs/verifier-results");
        ResultManager rm = verifierFrameworkContext.getResultManager();
        try {
            verifier.init(verifierFrameworkContext);
            verifier.verify();
        }
        catch (Exception e) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, "Could not verify successfully.");
            logRecord.setThrown(e);
            verifierFrameworkContext.getResultManager().log(logRecord);
        }
        try {
            verifier.generateReports();
        }
        catch (IOException ioe) {
            context.getLogger().warning("Can not generate verifier report: " + ioe.getMessage());
        }
        int failedCount = rm.getFailedCount() + rm.getErrorCount();
        if (failedCount != 0) {
            ((ExtendedDeploymentContext)context).clean();
            throw new DeploymentException(localStrings.getLocalString("deploy.failverifier", "Some verifier tests failed. Aborting deployment"));
        }
    }

    private boolean isVerifierInstalled() {
        try {
            Class.forName("com.sun.enterprise.tools.verifier.Verifier");
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            Logger.getAnonymousLogger().log(Level.FINE, "Verifier class not found: ", cnfe);
            return false;
        }
    }

    private String propertiesValue(Properties props, char sep) {
        StringBuilder sb = new StringBuilder();
        String currentSep = "";
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object v = props.get(key);
            sb.append(currentSep).append(key.toString()).append("=").append(v.toString());
            currentSep = String.valueOf(sep);
        }
        return sb.toString();
    }
}

