/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class Target {
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnv;

    public boolean isThisDAS() {
        return this.serverEnv.isDas();
    }

    public boolean isThisInstance() {
        return this.serverEnv.isInstance();
    }

    public boolean isCluster(String targetName) {
        return this.domain.getServerNamed(targetName) == null;
    }

    public Cluster getCluster(String targetName) {
        if (!this.isCluster(targetName)) {
            return null;
        }
        List clList = this.domain.getClusters().getCluster();
        for (Cluster cl : clList) {
            if (!targetName.equals(cl.getName())) continue;
            return cl;
        }
        return null;
    }

    public Config getClusterConfig(String targetName) {
        Cluster cl = this.getCluster(targetName);
        if (cl == null) {
            return null;
        }
        return this.domain.getConfigNamed(cl.getConfigRef());
    }

    public Cluster getClusterForInstance(String targetName) {
        if (this.isCluster(targetName)) {
            return this.getCluster(targetName);
        }
        String instanceCfgRef = this.domain.getServerNamed(targetName).getConfigRef();
        for (Cluster c : this.domain.getClusters().getCluster()) {
            if (!c.getConfigRef().equals(instanceCfgRef)) continue;
            return c;
        }
        return null;
    }

    public List<Server> getInstances(String targetName) {
        ArrayList<Server> instances = new ArrayList<Server>();
        if (this.domain.getServerNamed(targetName) != null) {
            instances.add(this.domain.getServerNamed(targetName));
        } else {
            Cluster cluster = this.getCluster(targetName);
            if (cluster != null) {
                String clusterConfigName = cluster.getConfigRef();
                List svrList = this.domain.getServers().getServer();
                for (Server svr : svrList) {
                    if (!clusterConfigName.equals(svr.getConfigRef())) continue;
                    instances.add(svr);
                }
            }
        }
        return instances;
    }

    public boolean isValid(String targetName) {
        if (this.isCluster(targetName)) {
            return true;
        }
        if (this.getInstances(targetName).size() != 0) {
            return true;
        }
        return this.domain.getConfigNamed(targetName) != null;
    }
}

