/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ClassModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.FieldModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.InterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.MethodModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ModelBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModelClassVisitor
implements ClassVisitor {
    private final ParsingContext ctx;
    private final TypeBuilder typeBuilder;
    TypeImpl type;
    boolean deepVisit = false;

    public ModelClassVisitor(ParsingContext ctx) {
        this.ctx = ctx;
        if (!(ctx.getTypes() instanceof TypeBuilder)) {
            throw new RuntimeException("Wrong context for this model class visitor");
        }
        this.typeBuilder = (TypeBuilder)((Object)ctx.getTypes());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String parentName = superName != null ? Type.getObjectType((String)superName).getClassName() : null;
        TypeProxy parent = parentName != null ? this.typeBuilder.getHolder(parentName) : null;
        String className = Type.getObjectType((String)name).getClassName();
        this.type = this.typeBuilder.getType(access, className, parent);
        this.deepVisit = this.ctx.getConfig().getInjectionTargetAnnotations().isEmpty();
        if (parent != null) {
            parent.getSubTypeRefs().add(this.type);
        }
        try {
            ClassModelImpl classModel = (ClassModelImpl)this.type;
            for (String intf : interfaces) {
                String interfaceName = Type.getObjectType((String)intf).getClassName();
                InterfaceModelImpl im = this.typeBuilder.getInterface(interfaceName);
                classModel.isImplementing(im);
                im.addImplementation(classModel);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        desc = this.unwrap(desc);
        AnnotationTypeImpl at = this.typeBuilder.getAnnotation(desc);
        final AnnotationModelImpl am = new AnnotationModelImpl(this.type, at);
        at.getReferences().add(this.type);
        this.type.addAnnotation(am);
        if (this.ctx.getConfig().getInjectionTargetAnnotations().contains(desc)) {
            System.out.println("Inspecting fields of " + this.type.getName());
            this.deepVisit = true;
        }
        return new AnnotationVisitor(){

            public void visit(String name, Object value) {
                am.addValue(name, value);
            }

            public void visitEnum(String name, String desc, String value) {
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return null;
            }

            public AnnotationVisitor visitArray(String name) {
                return null;
            }

            public void visitEnd() {
            }
        };
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        ClassModelImpl cm;
        if (!this.deepVisit) {
            return null;
        }
        try {
            cm = (ClassModelImpl)this.type;
        }
        catch (Exception e) {
            return null;
        }
        Type type = Type.getType((String)desc);
        if (type == Type.INT_TYPE || type == Type.BOOLEAN_TYPE) {
            return null;
        }
        TypeProxy fieldType = this.typeBuilder.getHolder(type.getClassName());
        final FieldModelImpl field = this.typeBuilder.getFieldModel(name, fieldType);
        fieldType.getFieldRefs().add(field);
        cm.addField(field);
        return new FieldVisitor(){

            public AnnotationVisitor visitAnnotation(String s, boolean b) {
                AnnotationTypeImpl annotationType = ModelClassVisitor.this.typeBuilder.getAnnotation(ModelClassVisitor.this.unwrap(s));
                AnnotationModelImpl annotationModel = new AnnotationModelImpl(field, annotationType);
                annotationType.getReferences().add(field);
                field.addAnnotation(annotationModel);
                return null;
            }

            public void visitAttribute(Attribute attribute) {
            }

            public void visitEnd() {
            }
        };
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.deepVisit) {
            return null;
        }
        MethodModelImpl method = new MethodModelImpl(new ModelBuilder(name, null));
        this.type.addMethod(method);
        return null;
    }

    public void visitEnd() {
    }

    private String unwrap(String desc) {
        return Type.getType((String)desc).getClassName();
    }
}

