/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Domain;
import org.glassfish.config.support.TargetValidator;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CommandTarget implements TargetValidator
{
    DOMAIN{

        public boolean isValid(Habitat habitat, String target) {
            return target.equals("domain");
        }

        public String getDescription() {
            return "Domain";
        }
    }
    ,
    DAS{

        public boolean isValid(Habitat habitat, String target) {
            return target.equals("server");
        }

        public String getDescription() {
            return "Default server";
        }
    }
    ,
    CLUSTERED_INSTANCE{

        public boolean isValid(Habitat habitat, String target) {
            Domain domain = habitat.getComponent(Domain.class);
            return domain.getClusterForInstance(target) != null;
        }

        public String getDescription() {
            return "Clustered Instance";
        }
    }
    ,
    STANDALONE_INSTANCE{

        public boolean isValid(Habitat habitat, String target) {
            Domain domain = habitat.getComponent(Domain.class);
            return domain.getServerNamed(target) != null;
        }

        public String getDescription() {
            return "Stand alone instance";
        }
    }
    ,
    CONFIG{

        public boolean isValid(Habitat habitat, String target) {
            Domain domain = habitat.getComponent(Domain.class);
            return domain.getConfigNamed(target) != null;
        }

        public String getDescription() {
            return "Config";
        }
    }
    ,
    CLUSTER{

        public boolean isValid(Habitat habitat, String target) {
            Domain domain = habitat.getComponent(Domain.class);
            return domain.getClusterNamed(target) != null;
        }

        public String getDescription() {
            return "Cluster";
        }
    };


    @Override
    public boolean isValid(Habitat habitat, String target) {
        return false;
    }

    @Override
    public String getDescription() {
        return this.name();
    }
}

