/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.JavaClassRunner;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommandContext;

public class RestartServer {
    ModulesRegistry registry;
    private Properties props;
    private Logger logger;
    private boolean verbose;
    private String classpath;
    private String classname;
    private String argsString;
    private String[] args;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartServer.class);
    private static final String magicProperty = "-DAS_RESTART=true";
    private static final String[] normalProps = new String[]{"-DAS_RESTART=true"};
    private static final String[] debuggerProps = new String[]{"-DAS_RESTART=true", "-Xdebug", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=1323"};

    protected final void setRegistry(ModulesRegistry registryIn) {
        this.registry = registryIn;
    }

    protected final void doExecute(AdminCommandContext context) {
        try {
            Collection<Module> modules;
            if (this.registry == null) {
                throw new NullPointerException(new LocalStringsImpl(this.getClass()).get("restart.server.internalError", new Object[]{"registry was not set"}));
            }
            this.init(context);
            if (!this.verbose) {
                this.reincarnate();
            }
            if ((modules = this.registry.getModules("com.sun.enterprise.osgi-adapter")).size() == 1) {
                Module mgmtAgentModule = modules.iterator().next();
                mgmtAgentModule.stop();
            } else {
                context.getLogger().warning(strings.get("restart.server.badNumModules", new Object[]{modules.size()}));
            }
        }
        catch (Exception e) {
            context.getLogger().severe(strings.get("restart.server.failure", new Object[]{e}));
        }
        System.exit(10);
    }

    private void init(AdminCommandContext context) throws IOException {
        this.logger = context.getLogger();
        String s = System.getProperty("com.sun.enterprise.glassfish.bootstrap.args");
        StringReader reader = new StringReader(s);
        this.props = new Properties();
        this.props.load(reader);
        this.verbose = Boolean.parseBoolean(this.props.getProperty("-verbose", "false"));
        this.logger.info(strings.get("restart.server.init"));
    }

    private void reincarnate() {
        try {
            if (this.setupReincarnationWithAsadmin() || this.setupReincarnationWithOther()) {
                this.doReincarnation();
            } else {
                this.logger.severe(strings.get("restart.server.noStartupInfo", new Object[]{strings.get("restart.server.asadminError"), strings.get("restart.server.nonAsadminError")}));
            }
        }
        catch (RDCException rdce) {
        }
        catch (Exception e) {
            this.logger.severe(strings.get("restart.server.internalError", new Object[]{e}));
        }
    }

    private void doReincarnation() throws RDCException {
        try {
            String[] props = normalProps;
            if (Boolean.parseBoolean(System.getenv("AS_SUPER_DEBUG"))) {
                props = debuggerProps;
            }
            new JavaClassRunner(this.classpath, props, this.classname, this.args);
        }
        catch (Exception e) {
            this.logger.severe(strings.get("restart.server.jvmError", new Object[]{e}));
            throw new RDCException();
        }
    }

    private boolean setupReincarnationWithAsadmin() throws RDCException {
        this.classpath = this.props.getProperty("-asadmin-classpath");
        this.classname = this.props.getProperty("-asadmin-classname");
        this.argsString = this.props.getProperty("-asadmin-args");
        return this.verify("restart.server.asadminError");
    }

    private boolean setupReincarnationWithOther() throws RDCException {
        this.classpath = this.props.getProperty("-startup-classpath");
        this.classname = this.props.getProperty("-startup-classname");
        this.argsString = this.props.getProperty("-startup-args");
        return this.verify("restart.server.nonAsadminError");
    }

    private boolean verify(String errorStringKey) throws RDCException {
        if (this.classpath == null && this.classname == null && this.argsString == null) {
            return false;
        }
        if (!this.ok(this.classpath) || !this.ok(this.classname) || this.argsString == null) {
            this.logger.severe(strings.get(errorStringKey));
            throw new RDCException();
        }
        this.args = this.argsString.split(",,,");
        return true;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static class RDCException
    extends Exception {
        private RDCException() {
        }
    }
}

