/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-application-ref")
@I18n(value="create.application.ref.command")
@Cluster(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class CreateApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject(name="default-instance-name")
    protected Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ReadableArchive archive;
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        if (!this.deployment.isRegistered(this.name)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        DeployCommandSupplementalInfo suppInfo = new DeployCommandSupplementalInfo();
        context.getActionReport().setResultType(DeployCommandSupplementalInfo.class, (Object)suppInfo);
        ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(this.name, this.target);
        if (applicationRef != null) {
            suppInfo.setAppRefExists(true);
            return;
        }
        Transaction t = new Transaction();
        File file = null;
        Object appRef = null;
        DeployCommandParameters commandParams = null;
        Properties contextProps = new Properties();
        Map modulePropsMap = null;
        ApplicationConfigInfo savedAppConfig = null;
        Application app = this.applications.getApplication(this.name);
        try {
            commandParams = app.getDeployParameters(null);
            commandParams.origin = OpsParams.Origin.load;
            commandParams.target = this.target;
            commandParams.virtualservers = this.virtualservers;
            commandParams.enabled = this.enabled;
            contextProps = app.getDeployProperties();
            modulePropsMap = app.getModulePropertiesMap();
            savedAppConfig = new ApplicationConfigInfo(app);
            URI uri = new URI(app.getLocation());
            file = new File(uri);
            if (!file.exists()) {
                report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            archive = this.archiveFactory.openArchive(file);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
            report.setMessage(localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(archive).build();
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)contextProps);
            String location = DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(app.getLocation()));
            appProps.setProperty("location", location);
            String appLocation = appProps.getProperty("appLocation");
            appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(appLocation)));
            String planLocation = appProps.getProperty("deploymentPlanLocation");
            if (planLocation != null) {
                appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible((URI)new URI(planLocation)));
            }
            savedAppConfig.store(appProps);
            if (modulePropsMap != null) {
                deploymentContext.setModulePropsMap(modulePropsMap);
            }
            if (this.domain.isCurrentInstanceMatchingTarget(this.target, this.server.getName())) {
                this.deployment.deploy(deploymentContext);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                try {
                    this.deployment.registerAppInDomainXML(null, (DeploymentContext)deploymentContext, t, true);
                    suppInfo.setDeploymentContext((DeploymentContext)deploymentContext);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to create application ref for " + this.name);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during creating application ref ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
        finally {
            try {
                archive.close();
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            }
        }
    }
}

