/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.universal.GFBase64Decoder;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.InjectionResolver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.ParamTokenizer;
import org.glassfish.common.util.admin.UnacceptableValueException;
import org.jvnet.hk2.component.ComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapInjectionResolver
extends InjectionResolver<Param> {
    private final CommandModel model;
    private final ParameterMap parameters;
    private final Map<String, File> optionNameToUploadedFileMap;
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MapInjectionResolver.class);

    public MapInjectionResolver(CommandModel model, ParameterMap parameters) {
        this(model, parameters, null);
    }

    public MapInjectionResolver(CommandModel model, ParameterMap parameters, Map<String, File> optionNameToUploadedFileMap) {
        super(Param.class);
        this.model = model;
        this.parameters = parameters;
        this.optionNameToUploadedFileMap = optionNameToUploadedFileMap;
    }

    @Override
    public boolean isOptional(AnnotatedElement element, Param annotation) {
        String name = CommandModel.getParamName((Param)annotation, (AnnotatedElement)element);
        CommandModel.ParamModel param = this.model.getModelFor(name);
        return param.getParam().optional();
    }

    @Override
    public Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
        List value;
        Param param = target.getAnnotation(Param.class);
        String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
        if (param.primary() && (value = this.parameters.get((Object)"DEFAULT")) != null && value.size() > 0) {
            for (int i = 0; i < value.size(); ++i) {
                String filePath = MapInjectionResolver.getUploadedFileParamValue("DEFAULT", type, this.optionNameToUploadedFileMap);
                if (filePath == null) continue;
                value.set(i, filePath);
            }
            this.parameters.set((Object)paramName, (Collection)value);
            return MapInjectionResolver.convertListToObject(target, type, value);
        }
        String paramValueStr = MapInjectionResolver.getParamValueString(this.parameters, param, target);
        String fileParamValueStr = MapInjectionResolver.getUploadedFileParamValue(paramName, type, this.optionNameToUploadedFileMap);
        if (fileParamValueStr != null) {
            paramValueStr = fileParamValueStr;
        }
        MapInjectionResolver.checkAgainstAcceptableValues(target, paramValueStr);
        if (paramValueStr != null) {
            return MapInjectionResolver.convertStringToObject(target, type, paramValueStr);
        }
        return MapInjectionResolver.getParamField(component, target);
    }

    public static String getUploadedFileParamValue(String fieldName, Class fieldType, Map<String, File> optionNameToFileMap) {
        if (optionNameToFileMap == null) {
            return null;
        }
        File uploadedFile = optionNameToFileMap.get(fieldName);
        if (uploadedFile != null && fieldType.isAssignableFrom(File.class)) {
            return uploadedFile.getAbsolutePath();
        }
        return null;
    }

    static String getParamValueString(ParameterMap parameters, Param param, AnnotatedElement target) {
        String paramValueStr = MapInjectionResolver.getParameterValue(parameters, CommandModel.getParamName((Param)param, (AnnotatedElement)target), true);
        if (paramValueStr == null && param.alias().length() > 0) {
            paramValueStr = MapInjectionResolver.getParameterValue(parameters, param.alias(), true);
        }
        if (paramValueStr == null) {
            paramValueStr = (String)parameters.getOne((Object)param.shortName());
        }
        if (paramValueStr == null && param.password()) {
            paramValueStr = MapInjectionResolver.getParameterValue(parameters, param.name(), true);
        }
        if (paramValueStr == null) {
            String defaultValue = param.defaultValue();
            paramValueStr = defaultValue.equals("") ? null : defaultValue;
        }
        return paramValueStr;
    }

    static Object getParamField(Object component, AnnotatedElement annotated) {
        try {
            if (annotated instanceof Field) {
                Field field = (Field)annotated;
                field.setAccessible(true);
                return ((Field)annotated).get(component);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    static String getParameterValue(ParameterMap params, String key, boolean ignoreCase) {
        if (ignoreCase) {
            for (Map.Entry entry : params.entrySet()) {
                String paramName = (String)entry.getKey();
                if (!paramName.equalsIgnoreCase(key)) continue;
                key = paramName;
                break;
            }
        }
        String value = (String)params.getOne((Object)key);
        if (key.startsWith(ASADMIN_CMD_PREFIX) && value != null) {
            try {
                GFBase64Decoder base64Decoder = new GFBase64Decoder();
                value = new String(base64Decoder.decodeBuffer(value));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return value;
    }

    static Object convertStringToObject(AnnotatedElement target, Class type, String paramValStr) {
        Param param = target.getAnnotation(Param.class);
        String[] paramValue = paramValStr;
        if (type.isAssignableFrom(String.class)) {
            paramValue = paramValStr;
        } else if (type.isAssignableFrom(Properties.class)) {
            paramValue = MapInjectionResolver.convertStringToProperties(paramValStr, param.separator());
        } else if (type.isAssignableFrom(List.class)) {
            paramValue = MapInjectionResolver.convertStringToList(paramValStr, param.separator());
        } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
            paramValue = MapInjectionResolver.convertStringToBoolean(paramName, paramValStr);
        } else if (type.isAssignableFrom(String[].class)) {
            paramValue = MapInjectionResolver.convertStringToStringArray(paramValStr, param.separator());
        } else if (type.isAssignableFrom(File.class)) {
            return new File(paramValStr);
        }
        return paramValue;
    }

    static Object convertListToObject(AnnotatedElement target, Class type, List<String> paramValList) {
        Param param = target.getAnnotation(Param.class);
        if (!param.multiple()) {
            if (paramValList.size() == 1) {
                return MapInjectionResolver.convertStringToObject(target, type, paramValList.get(0));
            }
            throw new UnacceptableValueException(localStrings.getLocalString("TooManyValues", "Invalid parameter: {0}.  This parameter may not have more than one value.", CommandModel.getParamName((Param)param, (AnnotatedElement)target)));
        }
        Object paramValue = paramValList;
        if (!type.isAssignableFrom(List.class)) {
            if (type.isAssignableFrom(String[].class)) {
                paramValue = paramValList.toArray(new String[paramValList.size()]);
            } else if (type.isAssignableFrom(Properties.class)) {
                paramValue = MapInjectionResolver.convertListToProperties((List<String>)paramValList);
            }
        }
        return paramValue;
    }

    private static Boolean convertStringToBoolean(String paramName, String s) {
        if (!MapInjectionResolver.ok(s)) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return Boolean.FALSE;
        }
        String msg = localStrings.getLocalString("UnacceptableBooleanValue", "Invalid parameter: {0}.  This boolean option must be set (case insensitive) to true or false.  Its value was set to {1}", paramName, s);
        throw new UnacceptableValueException(msg);
    }

    static Properties convertStringToProperties(String propsString, char sep) {
        Properties properties = new Properties();
        if (propsString != null) {
            ParamTokenizer stoken = new ParamTokenizer(propsString, sep);
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextTokenKeepEscapes();
                ParamTokenizer nameTok = new ParamTokenizer(token, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (name == null) {
                    throw new IllegalArgumentException(localStrings.getLocalString("PropertyMissingName", "Invalid property syntax, missing property name", propsString));
                }
                if (value == null) {
                    throw new IllegalArgumentException(localStrings.getLocalString("PropertyMissingValue", "Invalid property syntax, missing property value", token));
                }
                if (nameTok.hasMoreTokens()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("PropertyExtraEquals", "Invalid property syntax, \"=\" in value", token));
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    private static Properties convertListToProperties(List<String> propsList) {
        Properties properties = new Properties();
        if (propsList != null) {
            for (String prop : propsList) {
                ParamTokenizer nameTok = new ParamTokenizer(prop, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens() || name == null || value == null) {
                    throw new IllegalArgumentException(localStrings.getLocalString("InvalidPropertySyntax", "Invalid property syntax.", prop));
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    static List<String> convertStringToList(String listString, char sep) {
        ArrayList<String> list = new ArrayList<String>();
        if (listString != null) {
            ParamTokenizer ptoken = new ParamTokenizer(listString, sep);
            while (ptoken.hasMoreTokens()) {
                String token = ptoken.nextToken();
                list.add(token);
            }
        }
        return list;
    }

    static String[] convertStringToStringArray(String arrayString, char sep) {
        ParamTokenizer paramTok = new ParamTokenizer(arrayString, sep);
        ArrayList<String> strs = new ArrayList<String>();
        while (paramTok.hasMoreTokens()) {
            strs.add(paramTok.nextToken());
        }
        return strs.toArray(new String[strs.size()]);
    }

    private static void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
        Param param = target.getAnnotation(Param.class);
        String acceptable = param.acceptableValues();
        String paramName = CommandModel.getParamName((Param)param, (AnnotatedElement)target);
        if (MapInjectionResolver.ok(acceptable) && MapInjectionResolver.ok(paramValueStr)) {
            String[] ss;
            for (String s : ss = acceptable.split(",")) {
                if (!paramValueStr.equals(s.trim())) continue;
                return;
            }
            throw new UnacceptableValueException(localStrings.getLocalString("UnacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", paramName, paramValueStr, acceptable));
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

