/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.AbstractThreadPool;
import com.sun.grizzly.util.ThreadPoolMonitoringProbe;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncThreadPool
extends AbstractThreadPool {
    private final Queue<Runnable> workQueue;
    protected int maxQueuedTasks = -1;
    private final AtomicLong completedTasksCount = new AtomicLong();
    private int largestThreadPoolSize;

    public SyncThreadPool() {
        this("Grizzly", DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public SyncThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, null);
    }

    public SyncThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, threadFactory, new LinkedList<Runnable>(), -1);
    }

    public SyncThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, Queue<Runnable> workQueue, int maxQueuedTasks) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, threadFactory, new LinkedList<Runnable>(), maxQueuedTasks, null);
    }

    public SyncThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, Queue<Runnable> workQueue, int maxQueuedTasks, ThreadPoolMonitoringProbe probe) {
        super(probe, name, threadFactory, maxPoolSize);
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime < 0");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeUnit == null");
        }
        if (workQueue == null) {
            workQueue = new LinkedList<Runnable>();
        }
        this.setPoolSizes(corePoolsize, maxPoolSize);
        this.keepAliveTime = TimeUnit.MILLISECONDS.convert(keepAliveTime, timeUnit);
        this.workQueue = workQueue;
        this.maxQueuedTasks = maxQueuedTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.statelock;
        synchronized (object) {
            while (this.currentPoolSize < this.corePoolSize) {
                this.startWorker(new SyncThreadWorker(true));
            }
        }
    }

    public void stop() {
        this.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        Object object = this.statelock;
        synchronized (object) {
            boolean isCore;
            if (!this.running) {
                throw new RejectedExecutionException("ThreadPool is not running");
            }
            int idleThreadsNumber = this.currentPoolSize - this.activeThreadsCount;
            if ((this.maxQueuedTasks < 0 || this.workQueue.size() < this.maxQueuedTasks) && this.workQueue.offer(task)) {
                this.onTaskQueued(task);
            } else {
                this.onTaskQueueOverflow();
            }
            boolean bl = isCore = this.currentPoolSize < this.corePoolSize;
            if (isCore || this.currentPoolSize < this.maxPoolSize && idleThreadsNumber == 0) {
                this.startWorker(new SyncThreadWorker(isCore));
            } else if (idleThreadsNumber == 0) {
                this.onMaxNumberOfThreadsReached();
            } else {
                this.statelock.notify();
            }
        }
    }

    @Override
    protected void startWorker(AbstractThreadPool.Worker wt) {
        super.startWorker(wt);
        ++this.currentPoolSize;
        ++this.activeThreadsCount;
        if (this.currentPoolSize > this.largestThreadPoolSize) {
            this.largestThreadPoolSize = this.currentPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.statelock;
        synchronized (object) {
            return !this.running && this.workers.isEmpty();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        Object object = this.statelock;
        synchronized (object) {
            return this.activeThreadsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskCount() {
        Object object = this.statelock;
        synchronized (object) {
            return this.workQueue.size();
        }
    }

    @Override
    public long getCompletedTaskCount() {
        return this.completedTasksCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestPoolSize() {
        Object object = this.statelock;
        synchronized (object) {
            return this.largestThreadPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        Object object = this.statelock;
        synchronized (object) {
            return this.currentPoolSize;
        }
    }

    @Override
    public Queue<Runnable> getQueue() {
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueSize() {
        Object object = this.statelock;
        synchronized (object) {
            return this.workQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxQueuedTasksCount() {
        Object object = this.statelock;
        synchronized (object) {
            return this.maxQueuedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxQueuedTasksCount(int maxQueuedTasks) {
        Object object = this.statelock;
        synchronized (object) {
            this.maxQueuedTasks = maxQueuedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPoolSizes(int corePoolSize, int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolSize(corePoolSize, maxPoolSize);
            this.corePoolSize = corePoolSize;
            this.maxPoolSize = maxPoolSize;
        }
    }

    @Override
    protected void afterExecute(Thread thread, Runnable r, Throwable t) {
        super.afterExecute(thread, r, t);
        this.completedTasksCount.incrementAndGet();
    }

    @Override
    public String toString() {
        return super.toString() + ", min-threads=" + this.getCorePoolSize() + ", max-threads=" + this.getMaximumPoolSize() + ", max-queue-size=" + this.getMaxQueuedTasksCount();
    }

    protected class SyncThreadWorker
    extends AbstractThreadPool.Worker {
        private final boolean core;

        public SyncThreadWorker(boolean core) {
            this.core = core;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Runnable getTask() throws InterruptedException {
            Object object = SyncThreadPool.this.statelock;
            synchronized (object) {
                try {
                    --SyncThreadPool.this.activeThreadsCount;
                    if (!this.core && SyncThreadPool.this.currentPoolSize > SyncThreadPool.this.maxPoolSize) {
                        Runnable runnable = null;
                        return runnable;
                    }
                    Runnable r = (Runnable)SyncThreadPool.this.workQueue.poll();
                    long localKeepAlive = SyncThreadPool.this.keepAliveTime;
                    while (r == null) {
                        long startTime = System.currentTimeMillis();
                        SyncThreadPool.this.statelock.wait(localKeepAlive);
                        r = (Runnable)SyncThreadPool.this.workQueue.poll();
                        if (this.core || r == null && (localKeepAlive -= System.currentTimeMillis() - startTime) >= 100L) continue;
                    }
                    Runnable runnable = r;
                    return runnable;
                }
                finally {
                    ++SyncThreadPool.this.activeThreadsCount;
                }
            }
        }
    }
}

