/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class Target {
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    Habitat habitat;

    public boolean isThisDAS() {
        return this.serverEnv.isDas();
    }

    public boolean isThisInstance() {
        return this.serverEnv.isInstance();
    }

    public boolean isCluster(String targetName) {
        return this.domain.getClusterNamed(targetName) != null;
    }

    public Cluster getCluster(String targetName) {
        return this.domain.getClusterNamed(targetName);
    }

    public Config getClusterConfig(String targetName) {
        Cluster cl = this.getCluster(targetName);
        if (cl == null) {
            return null;
        }
        return this.domain.getConfigNamed(cl.getConfigRef());
    }

    public Config getServerConfig(String targetName) {
        Server s = this.domain.getServerNamed(targetName);
        if (s == null) {
            return null;
        }
        return this.domain.getConfigNamed(s.getConfigRef());
    }

    public Config getConfig(String targetName) {
        if (CommandTarget.CONFIG.isValid(this.habitat, targetName)) {
            return this.domain.getConfigNamed(targetName);
        }
        if (CommandTarget.DAS.isValid(this.habitat, targetName)) {
            return this.getServerConfig(targetName);
        }
        if (CommandTarget.STANDALONE_INSTANCE.isValid(this.habitat, targetName)) {
            return this.getServerConfig(targetName);
        }
        if (CommandTarget.CLUSTER.isValid(this.habitat, targetName)) {
            return this.getClusterConfig(targetName);
        }
        return null;
    }

    public Cluster getClusterForInstance(String targetName) {
        return this.domain.getClusterForInstance(targetName);
    }

    public List<Server> getInstances(String targetName) {
        List<Object> instances = new ArrayList<Server>();
        if (CommandTarget.DOMAIN.isValid(this.habitat, targetName)) {
            return instances;
        }
        if (CommandTarget.DAS.isValid(this.habitat, targetName)) {
            return instances;
        }
        if (CommandTarget.STANDALONE_INSTANCE.isValid(this.habitat, targetName)) {
            instances.add(this.domain.getServerNamed(targetName));
        }
        if (CommandTarget.CLUSTER.isValid(this.habitat, targetName)) {
            instances = this.getCluster(targetName).getInstances();
        }
        if (CommandTarget.CONFIG.isValid(this.habitat, targetName)) {
            List targets = this.domain.getAllTargets();
            for (String aTarget : targets) {
                if (CommandTarget.CLUSTER.isValid(this.habitat, aTarget) && this.getCluster(aTarget).getConfigRef().equals(targetName)) {
                    instances.addAll(this.getCluster(aTarget).getInstances());
                }
                if (!CommandTarget.STANDALONE_INSTANCE.isValid(this.habitat, aTarget) || !this.domain.getServerNamed(aTarget).getConfigRef().equals(targetName)) continue;
                instances.add(this.domain.getServerNamed(aTarget));
            }
        }
        return instances;
    }

    public boolean isValid(String targetName) {
        if (this.isCluster(targetName)) {
            return true;
        }
        if (this.getInstances(targetName).size() != 0) {
            return true;
        }
        return this.domain.getConfigNamed(targetName) != null;
    }
}

