/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.component.Wombs;
import org.jvnet.hk2.junit.Hk2TestServices;

public class Hk2Runner
extends Runner {
    final Class<?> testClass;
    final Description description;
    final Map<Description, Method> testMethods = new LinkedHashMap<Description, Method>();
    static final Hk2TestServices singleton = new Hk2TestServices();

    public Hk2Runner(Class testClass) {
        this.testClass = testClass;
        this.description = Description.createSuiteDescription((Class)testClass);
        for (Method m : testClass.getDeclaredMethods()) {
            if (m.getAnnotation(Test.class) == null) continue;
            Description testDescription = Description.createTestDescription((Class)testClass, (String)m.getName());
            this.description.addChild(testDescription);
            this.testMethods.put(testDescription, m);
        }
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        Object instance;
        if (this.testClass.isAnnotationPresent(Ignore.class)) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        for (Method m : this.testClass.getMethods()) {
            Failure failure;
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(BeforeClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
        }
        Habitat habitat = singleton.getHabitat();
        Womb<?> womb = Wombs.create(this.testClass, habitat, new MultiMap<String, String>());
        try {
            instance = womb.get();
        }
        catch (ComponentException e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            return;
        }
        for (Description testDescription : this.description.getChildren()) {
            Failure failure;
            Method m = this.testMethods.get(testDescription);
            if (m.isAnnotationPresent(Ignore.class)) {
                notifier.fireTestIgnored(testDescription);
                continue;
            }
            notifier.fireTestStarted(testDescription);
            try {
                m.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(testDescription, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(testDescription, e.getTargetException());
                notifier.fireTestFailure(failure);
            }
            notifier.fireTestFinished(testDescription);
        }
        for (Method m : this.testClass.getMethods()) {
            Failure failure;
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(AfterClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
        }
    }

    public static Habitat getHabitat() {
        return singleton.getHabitat();
    }
}

