/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.tf;

import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorFactory;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorFactoryDefaults;
import com.sun.corba.ee.spi.orbutil.tf.annotation.MethodMonitorGroup;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MethodMonitorRegistry {
    private static final Map<Class<?>, List<String>> classToMNames = new HashMap();
    private static final Map<Class<?>, Map<Class<? extends Annotation>, SynchronizedHolder<MethodMonitor>>> classToAnnoMM = new HashMap();
    private static final Map<Class<? extends Annotation>, Set<Class<? extends Annotation>>> subgroups = new HashMap<Class<? extends Annotation>, Set<Class<? extends Annotation>>>();
    private static final Map<Class<? extends Annotation>, Set<Class<? extends Annotation>>> subgroupsTC = new HashMap<Class<? extends Annotation>, Set<Class<? extends Annotation>>>();
    private static final Map<Class<? extends Annotation>, Set<Class<?>>> annotationToClasses = new HashMap();
    private static final Map<Class<? extends Annotation>, MethodMonitorFactory> annotationToMMF = new HashMap<Class<? extends Annotation>, MethodMonitorFactory>();
    private static final Map<Class<? extends Annotation>, Set<MethodMonitorFactory>> annotationToMMFSets = new HashMap<Class<? extends Annotation>, Set<MethodMonitorFactory>>();
    private static final Map<Class<? extends Annotation>, MethodMonitorFactory> annotationToMMFComposition = new HashMap<Class<? extends Annotation>, MethodMonitorFactory>();

    private static void updateTracedClass(Class<?> cls) {
        Map<Class<? extends Annotation>, SynchronizedHolder<MethodMonitor>> map = classToAnnoMM.get(cls);
        for (Map.Entry<Class<? extends Annotation>, SynchronizedHolder<MethodMonitor>> entry : map.entrySet()) {
            MethodMonitorFactory mmf = annotationToMMFComposition.get(entry.getKey());
            if (mmf == null) {
                entry.getValue().content(null);
                continue;
            }
            entry.getValue().content(mmf.create(cls));
        }
    }

    private static void updateAnnotation(Class<? extends Annotation> annot) {
        HashSet<MethodMonitorFactory> mmfs = new HashSet<MethodMonitorFactory>();
        annotationToMMFSets.put(annot, mmfs);
        Set<Class<? extends Annotation>> relatedAnnos = subgroupsTC.get(annot);
        for (Class<? extends Annotation> key : relatedAnnos) {
            MethodMonitorFactory mmf = annotationToMMF.get(key);
            if (mmf == null) continue;
            mmfs.add(mmf);
        }
        annotationToMMFComposition.put(annot, MethodMonitorFactoryDefaults.compose(mmfs));
        Set<Class<?>> classes = annotationToClasses.get(annot);
        if (classes != null) {
            for (Class<?> cls : classes) {
                MethodMonitorRegistry.updateTracedClass(cls);
            }
        }
    }

    private static void doFullUpdate() {
        for (Class<? extends Annotation> clazz : annotationToMMF.keySet()) {
            MethodMonitorRegistry.updateAnnotation(clazz);
        }
        for (Class<Annotation> clazz : classToAnnoMM.keySet()) {
            MethodMonitorRegistry.updateTracedClass(clazz);
        }
    }

    private static boolean scanClassAnnotations(Class<?> cls) {
        boolean updated = false;
        boolean hasMMAnnotation = false;
        for (Annotation anno : cls.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            MethodMonitorGroup mmg = annoClass.getAnnotation(MethodMonitorGroup.class);
            if (mmg == null) continue;
            hasMMAnnotation = true;
            Set<Class<?>> target = annotationToClasses.get(annoClass);
            if (target == null) {
                target = new HashSet();
                annotationToClasses.put(annoClass, target);
            }
            target.add(cls);
            if (!MethodMonitorRegistry.scanAnnotation(annoClass, mmg)) continue;
            updated = true;
        }
        if (!hasMMAnnotation) {
            throw new RuntimeException("Class " + cls + " is not traceable");
        }
        return updated;
    }

    private static boolean scanAnnotation(Class<? extends Annotation> annoClass, MethodMonitorGroup mmg) {
        boolean updated = false;
        if (!subgroups.containsKey(annoClass)) {
            updated = true;
            HashSet<Class<? extends Annotation>> acs = new HashSet<Class<? extends Annotation>>(Arrays.asList(mmg.value()));
            subgroups.put(annoClass, acs);
            MethodMonitorRegistry.computeTransitiveClosure();
        }
        return updated;
    }

    private static void computeTransitiveClosure() {
        subgroupsTC.clear();
        for (Class<? extends Annotation> anno : subgroups.keySet()) {
            HashSet memset = new HashSet();
            subgroupsTC.put(anno, memset);
        }
        for (Class<? extends Annotation> anno : subgroupsTC.keySet()) {
            MethodMonitorRegistry.dfs(anno, anno);
        }
    }

    private static void dfs(Class<? extends Annotation> src, Class<? extends Annotation> dest) {
        Set<Class<? extends Annotation>> images = subgroupsTC.get(src);
        images.add(dest);
        for (Class<? extends Annotation> anno : subgroups.get(dest)) {
            if (images.contains(anno)) continue;
            MethodMonitorRegistry.dfs(src, anno);
        }
    }

    public static void registerClass(Class<?> cls, List<String> methodNames, Map<Class<? extends Annotation>, SynchronizedHolder<MethodMonitor>> annoMM) {
        boolean fullUpdate = MethodMonitorRegistry.scanClassAnnotations(cls);
        classToMNames.put(cls, methodNames);
        classToAnnoMM.put(cls, annoMM);
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        } else {
            MethodMonitorRegistry.updateTracedClass(cls);
        }
    }

    public static String getMethodName(Class<?> cls, int identifier) {
        List<String> names = classToMNames.get(cls);
        if (names == null) {
            throw new RuntimeException("Class " + cls + " not found in map");
        }
        if (identifier < 0 || identifier >= names.size()) {
            throw new RuntimeException("identifier is out of range");
        }
        return names.get(identifier);
    }

    public static int getMethodIdentifier(Class<?> cls, String mname) {
        List<String> names = classToMNames.get(cls);
        if (names == null) {
            throw new RuntimeException("Class " + cls + " not found in map");
        }
        for (int ctr = 0; ctr < names.size(); ++ctr) {
            String str = names.get(ctr);
            if (!str.equals(mname)) continue;
            return ctr;
        }
        return -1;
    }

    private static final MethodMonitorGroup checkAnnotation(Class<? extends Annotation> annoClass) {
        MethodMonitorGroup mmg = annoClass.getAnnotation(MethodMonitorGroup.class);
        if (mmg == null) {
            throw new RuntimeException("Annotation " + annoClass + " does not have the MethodMonitorGroup annotation");
        }
        return mmg;
    }

    public static void register(Class<? extends Annotation> annot, MethodMonitorFactory mmf) {
        boolean fullUpdate = MethodMonitorRegistry.scanAnnotation(annot, MethodMonitorRegistry.checkAnnotation(annot));
        annotationToMMF.put(annot, mmf);
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        } else {
            MethodMonitorRegistry.updateAnnotation(annot);
        }
    }

    public static void clear(Class<? extends Annotation> annot) {
        boolean fullUpdate = MethodMonitorRegistry.scanAnnotation(annot, MethodMonitorRegistry.checkAnnotation(annot));
        annotationToMMF.remove(annot);
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        } else {
            MethodMonitorRegistry.updateAnnotation(annot);
        }
    }

    public static MethodMonitorFactory registeredFactory(Class<? extends Annotation> annot) {
        boolean fullUpdate = MethodMonitorRegistry.scanAnnotation(annot, MethodMonitorRegistry.checkAnnotation(annot));
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        }
        return annotationToMMF.get(annot);
    }

    public static MethodMonitor getMethodMonitorForClass(Class<?> cls, Class<? extends Annotation> annot) {
        Map<Class<? extends Annotation>, SynchronizedHolder<MethodMonitor>> map = classToAnnoMM.get(cls);
        if (map == null) {
            throw new RuntimeException("Class " + cls + " is not a traced class.");
        }
        SynchronizedHolder<MethodMonitor> holder = map.get(annot);
        if (holder == null) {
            throw new RuntimeException("Annotation " + annot + " is not a tracing annotation defined on class " + cls);
        }
        return holder.content();
    }
}

