/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.Constants;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.SecKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ServerHandShake
extends HandShake {
    private static final byte[] normalResponse = Charset.forName("ASCII").encode("HTTP/1.1 101 Web Socket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\n").array();
    private static final byte[] locationResponse = Charset.forName("ASCII").encode("\r\nWebSocket-Location: ").array();
    private static final byte[] protocolResponse = Charset.forName("ASCII").encode("\r\nWebSocket-Protocol: ").array();
    private byte[] serverSecKey;

    public ServerHandShake(ClientHandShake client) {
        super(client.isSecure(), client.getOrigin(), client.getServerHostName(), client.getPort(), client.getResourcePath());
        this.setSubProtocol(client.getSubProtocol());
        if (client.getKey3() != null) {
            this.serverSecKey = SecKey.generateServerKey(client.getKey1(), client.getKey2(), client.getKey3());
        }
    }

    public ByteBuffer generate() {
        try {
            ByteArrayOutputStream bb = new ByteArrayOutputStream();
            bb.write(normalResponse);
            if (this.serverSecKey != null) {
                this.write76Response(bb);
            } else {
                this.write75Response(bb);
            }
            bb.write(Constants.CRLF_BYTES);
            ByteBuffer buffer = ByteBuffer.allocate(bb.size());
            buffer.put(bb.toByteArray());
            buffer.flip();
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void write75Response(ByteArrayOutputStream bb) throws IOException {
        this.write(bb, "WebSocket-Origin", this.getOrigin());
        this.write(bb, "WebSocket-Location", this.getLocation());
        String protocol = this.getSubProtocol();
        if (protocol != null) {
            this.write(bb, "WebSocket-Protocol", protocol);
        }
    }

    private void write76Response(ByteArrayOutputStream bb) throws IOException {
        this.write(bb, "Sec-WebSocket-Origin", this.getOrigin());
        this.write(bb, "Sec-WebSocket-Location", this.getLocation());
        String protocol = this.getSubProtocol();
        if (protocol != null) {
            this.write(bb, "Sec-WebSocket-Protocol", protocol);
        }
        bb.write(Constants.CRLF_BYTES);
        bb.write(this.serverSecKey);
        bb.write(Constants.CRLF_BYTES);
    }

    private void write(ByteArrayOutputStream bb, String header, String value) throws IOException {
        bb.write((header + ": " + value).getBytes("ASCII"));
        bb.write(Constants.CRLF_BYTES);
    }

    public void prepare(Response response) throws IOException {
        response.setStatus(101);
        response.setMessage("Web Socket Protocol Handshake");
        response.setHeader("Upgrade", "WebSocket");
        response.setHeader("Connection", "Upgrade");
        if (this.serverSecKey == null) {
            response.setHeader("WebSocket-Origin", this.getOrigin());
            response.setHeader("WebSocket-Location", this.getLocation());
            if (this.getSubProtocol() != null) {
                response.setHeader("WebSocket-Protocol", this.getSubProtocol());
            }
        } else {
            response.setHeader("Sec-WebSocket-Origin", this.getOrigin());
            response.setHeader("Sec-WebSocket-Location", this.getLocation());
            if (this.getSubProtocol() != null) {
                response.setHeader("Sec-WebSocket-Protocol", this.getSubProtocol());
            }
        }
        if (this.serverSecKey != null) {
            OutputBuffer buffer = response.getOutputBuffer();
            ByteChunk chunk = new ByteChunk(this.serverSecKey.length + Constants.CRLF_BYTES.length);
            chunk.append(this.serverSecKey, 0, this.serverSecKey.length);
            chunk.append(Constants.CRLF_BYTES, 0, Constants.CRLF_BYTES.length);
            buffer.doWrite(chunk, response);
        }
        response.flush();
    }
}

