/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;

public class GlassFishActivator
implements BundleActivator {
    private ServiceTracker caTracker;
    private volatile Configuration config;
    private BundleContext bundleContext;
    public static final String gfpid = "com.sun.enterprise.glassfish.bootstrap.GlassFish";
    private static final String hk2pid = "org.jvnet.hk2.osgiadapter.StartupContextService";

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.startBundles();
        String lineformat = context.getProperty("com.sun.enterprise.glassfish.bootstrap.args");
        if (lineformat != null) {
            Properties args = new Properties();
            StringReader reader = new StringReader(lineformat);
            args.load(reader);
            this.caTracker = new CATracker(args);
            this.caTracker.open();
        } else {
            Properties p = new Properties();
            p.setProperty("service.pid", gfpid);
            context.registerService(ManagedService.class.getName(), (Object)new ManagedService(){

                public void updated(Dictionary dictionary) throws ConfigurationException {
                    try {
                        if (dictionary != null) {
                            Properties args = GlassFishActivator.this.dict2Properties(dictionary);
                            GlassFishActivator.this.caTracker = new CATracker(args);
                            GlassFishActivator.this.caTracker.open();
                        } else {
                            GlassFishActivator.this.deleteConfig();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Dictionary)p);
        }
        this.startGlassFish();
    }

    private Properties dict2Properties(Dictionary dictionary) {
        Properties args = new Properties();
        Enumeration e = dictionary.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            String v = dictionary.get(k).toString();
            args.put(k, v);
        }
        return args;
    }

    public void stop(BundleContext context) throws Exception {
        this.stopBundle("com.sun.enterprise.osgi-adapter");
        if (this.config != null) {
            this.config.delete();
        }
        if (this.caTracker != null) {
            this.caTracker.close();
        }
    }

    private void setEnv(Properties properties) {
        ASMainHelper helper = new ASMainHelper(Logger.getAnonymousLogger());
        File installRoot = new File(properties.getProperty("com.sun.aas.installRoot"));
        File instanceRoot = new File(properties.getProperty("com.sun.aas.instanceRoot"));
        System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        Properties asenv = helper.parseAsEnv(installRoot);
        for (String s : asenv.stringPropertyNames()) {
            System.setProperty(s, asenv.getProperty(s));
        }
        System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
    }

    private void startGlassFish() {
        ServiceTracker gfKernelTracker = new ServiceTracker(this.bundleContext, ModuleStartup.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                ModuleStartup gfKernel = (ModuleStartup)this.context.getService(reference);
                System.out.println("Starting " + gfKernel);
                gfKernel.start();
                GlassFishActivator.this.startPostStartupBundles();
                this.close();
                return super.addingService(reference);
            }
        };
        gfKernelTracker.open();
    }

    private void startBundles() {
        this.startConfigAdmin();
        this.startBundle("com.sun.enterprise.osgi-adapter");
    }

    private void startPostStartupBundles() {
        this.startBundle("org.apache.felix.shell");
        this.startBundle("org.apache.felix.org.apache.felix.shell.remote");
        this.startBundle("org.apache.felix.fileinstall");
    }

    private void startConfigAdmin() {
        ServiceReference sr = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (sr == null) {
            this.startBundle("org.apache.felix.configadmin");
        } else {
            this.bundleContext.ungetService(sr);
        }
    }

    private void startBundle(String bsn) {
        Bundle b = this.findBundle(bsn);
        if (b != null) {
            try {
                b.start(1);
            }
            catch (BundleException e) {
                System.out.println("Failed to start: " + bsn);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can't locate bundle: " + bsn);
        }
    }

    private void stopBundle(String bsn) {
        Bundle b = this.findBundle(bsn);
        if (b != null) {
            try {
                b.stop(1);
            }
            catch (BundleException e) {
                System.out.println("Failed to stop: " + bsn);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can't locate bundle: " + bsn);
        }
    }

    private Bundle findBundle(String bsn) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!bsn.equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    private void updateConfig(Properties properties, ConfigurationAdmin ca) throws Exception {
        this.setEnv(properties);
        this.config = ca.getConfiguration(hk2pid, null);
        this.config.update((Dictionary)properties);
    }

    private void deleteConfig() throws IOException {
        if (this.config != null) {
            this.config.delete();
            this.config = null;
        }
    }

    private class CATracker
    extends ServiceTracker {
        Properties properties;

        public CATracker(Properties properties) {
            super(GlassFishActivator.this.bundleContext, ConfigurationAdmin.class.getName(), null);
            this.properties = properties;
        }

        public Object addingService(ServiceReference reference) {
            try {
                ConfigurationAdmin ca = (ConfigurationAdmin)this.context.getService(reference);
                assert (ca != null);
                GlassFishActivator.this.updateConfig(this.properties, ca);
            }
            catch (Exception ioe) {
                throw new RuntimeException(ioe);
            }
            return super.addingService(reference);
        }
    }
}

