/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.InstanceCommandExecutor;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.config.support.CommandTarget;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterOperationUtil {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(ClusterOperationUtil.class);

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters, Habitat habitat) {
        ActionReport.ExitCode returnValue;
        block12: {
            returnValue = ActionReport.ExitCode.SUCCESS;
            InstanceState instanceState = (InstanceState)habitat.getComponent(InstanceState.class);
            try {
                List<InstanceCommandExecutor> execList = ClusterOperationUtil.getInstanceCommandList(commandName, instancesForReplication, context.getLogger(), habitat);
                for (InstanceCommandExecutor rac : execList) {
                    ActionReport aReport = context.getActionReport().addSubActionsReport();
                    try {
                        rac.executeCommand(parameters);
                        aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        if (StringUtils.ok(rac.getCommandOutput())) {
                            aReport.setMessage(rac.getServer().getName() + " : " + rac.getCommandOutput());
                            continue;
                        }
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandSuccessful", "Command {0} executed successfully on server instance {1}", commandName, rac.getServer().getName()));
                    }
                    catch (CommandException cmdEx) {
                        ActionReport.ExitCode finalResult;
                        if (cmdEx.getCause() instanceof ConnectException) {
                            finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)offlinePolicy, (ActionReport.ExitCode)ActionReport.ExitCode.WARNING);
                            if (!finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.warnoffline", "WARNING : Instance {0} seems to be offline; Command was not replicated to that instance", rac.getServer().getName()));
                            }
                        } else {
                            finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                            if (finalResult.equals((Object)ActionReport.ExitCode.FAILURE)) {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandFailed", "Command {0} failed on server instance {1} : {2}", commandName, rac.getServer().getName(), cmdEx.getMessage()));
                            } else {
                                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandWarning", "WARNING : Command {0} did not complete successfully on server instance {1} : {2}", commandName, rac.getServer().getName(), cmdEx.getMessage()));
                            }
                        }
                        aReport.setActionExitCode(finalResult);
                        if (returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            returnValue = finalResult;
                        }
                        instanceState.setState(rac.getServer().getName(), InstanceState.StateType.RESTART_REQUIRED);
                    }
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                ActionReport.ExitCode finalResult = FailurePolicy.applyFailurePolicy((FailurePolicy)failPolicy, (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                aReport.setActionExitCode(finalResult);
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication : {0}", ex.getMessage()));
                context.getLogger().severe("Error during command replication; Reason : " + ex.getLocalizedMessage());
                if (!returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) break block12;
                returnValue = finalResult;
            }
        }
        return returnValue;
    }

    public static ActionReport.ExitCode replicateCommand(String commandName, FailurePolicy failPolicy, FailurePolicy offlinePolicy, Collection<String> targetNames, AdminCommandContext context, ParameterMap parameters, Habitat habitat) {
        ActionReport.ExitCode result = ActionReport.ExitCode.SUCCESS;
        Target targetService = (Target)habitat.getComponent(Target.class);
        for (String t : targetNames) {
            if (CommandTarget.DAS.isValid(habitat, t) || CommandTarget.DOMAIN.isValid(habitat, t)) continue;
            parameters.set((Object)"target", (Object)t);
            ActionReport.ExitCode returnValue = ClusterOperationUtil.replicateCommand(commandName, failPolicy, offlinePolicy, targetService.getInstances(t), context, parameters, habitat);
            if (returnValue.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
            result = returnValue;
        }
        return result;
    }

    private static List<InstanceCommandExecutor> getInstanceCommandList(String commandName, List<Server> servers, Logger logger, Habitat habitat) throws CommandException {
        ArrayList<InstanceCommandExecutor> list = new ArrayList<InstanceCommandExecutor>();
        RemoteInstanceCommandHelper rich = new RemoteInstanceCommandHelper(habitat);
        for (Server svr : servers) {
            String host = rich.getHost(svr);
            int port = rich.getAdminPort(svr);
            list.add(new InstanceCommandExecutor(commandName, svr, host, port, logger));
        }
        return list;
    }
}

