/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.common.util.admin.ParamTokenizer;

public class ManagedFile {
    final File file;
    final int maxHoldingTime;
    final int timeOut;
    final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    final RefCounterLock rl = new RefCounterLock(this.rwl.readLock(), true);
    final RefCounterLock wl = new RefCounterLock(this.rwl.writeLock(), false);
    final Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();
    static final Logger logger = LogDomains.getLogger(ManagedFile.class, "javax.enterprise.system.tools.admin");
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ParamTokenizer.class);

    public ManagedFile(File file, int timeOut, int maxHoldingTime) throws IOException {
        this.file = file;
        this.maxHoldingTime = maxHoldingTime;
        this.timeOut = timeOut;
    }

    public Lock accessWrite() throws IOException, TimeoutException {
        this.wl._lock();
        return this.wl;
    }

    public Lock accessRead() throws IOException, TimeoutException {
        this.rl._lock();
        return this.rl;
    }

    private class RefCounterLock
    implements Lock {
        final Lock lock;
        final boolean read;
        final AtomicInteger refs = new AtomicInteger(0);
        FileLock fileLock;
        RandomAccessFile raf;
        FileChannel fc;
        Timer timer;

        private FileLock get(FileChannel fc, boolean shared) throws IOException, TimeoutException {
            FileLock fl;
            boolean wasInterrupted = false;
            Thread current = Thread.currentThread();
            ManagedFile.this.waiters.add(current);
            long endTime = System.currentTimeMillis() + (long)ManagedFile.this.timeOut;
            int individualWaitTime = ManagedFile.this.timeOut / 10;
            while (ManagedFile.this.waiters.peek() != current || (fl = this.getLock(fc, shared)) == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Waiting..." + individualWaitTime);
                }
                if (System.currentTimeMillis() > endTime) {
                    throw new TimeoutException(localStrings.getLocalString("FileLockTimeOut", "time out expired on locking {0}", ManagedFile.this.file.getPath()));
                }
                try {
                    Thread.sleep(individualWaitTime);
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
                if (!Thread.interrupted()) continue;
                wasInterrupted = true;
            }
            ManagedFile.this.waiters.remove();
            if (wasInterrupted) {
                current.interrupt();
            }
            return fl;
        }

        private FileLock getLock(FileChannel fc, boolean shared) throws IOException {
            try {
                return fc.lock(0L, Long.MAX_VALUE, shared);
            }
            catch (OverlappingFileLockException e) {
                return null;
            }
        }

        private synchronized FileLock access(boolean shared, String mode, int timeOut) throws IOException, TimeoutException {
            this.raf = new RandomAccessFile(ManagedFile.this.file, mode);
            this.fc = this.raf.getChannel();
            final FileLock fl = this.get(this.fc, shared);
            if (ManagedFile.this.maxHoldingTime != -1) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    public void run() {
                        try {
                            if (fl.isValid()) {
                                logger.severe(localStrings.getLocalString("FileLockNotReleased", "File Lock not released on {0}", ManagedFile.this.file.getPath()));
                                RefCounterLock.this.release(fl);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }, timeOut);
            }
            return fl;
        }

        private synchronized void release(FileLock lock) throws IOException {
            lock.release();
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            if (this.fc != null) {
                this.fc.close();
                this.fc = null;
            }
        }

        private RefCounterLock(Lock lock, boolean read) {
            this.lock = lock;
            this.read = read;
        }

        public void _lock() throws IOException, TimeoutException {
            this.lock.lock();
            if (this.refs.incrementAndGet() == 1) {
                this.fileLock = this.read ? this.access(true, "r", ManagedFile.this.maxHoldingTime) : this.access(false, "rw", ManagedFile.this.maxHoldingTime);
            }
        }

        public void lock() {
            throw new UnsupportedOperationException();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
            this.refs.incrementAndGet();
        }

        public boolean tryLock() {
            boolean result = this.lock.tryLock();
            if (result) {
                this.refs.incrementAndGet();
            }
            return result;
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            boolean result = this.lock.tryLock(time, unit);
            if (result) {
                this.refs.incrementAndGet();
            }
            return result;
        }

        public void unlock() {
            this.lock.unlock();
            if (this.refs.decrementAndGet() == 0) {
                try {
                    this.release(this.fileLock);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public Condition newCondition() {
            return this.lock.newCondition();
        }
    }
}

