/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.branding;

import java.util.PropertyResourceBundle;
import org.glassfish.api.branding.Branding;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class GlassFishBranding
implements Branding,
PostConstruct {
    private String product_name = "GlassFish Server Open Source Edition";
    private String abbrev_product_name = "glassfish";
    private String full_version = "3.1-b11";
    private String major_version = "3";
    private String minor_version = "1";
    private String update_version = "";
    private String build_id = "java_re-private";
    private String version_prefix = "";
    private String version_suffix = "";
    private PropertyResourceBundle vRes;
    private boolean fullVersionSet = false;

    public void postConstruct() {
        try {
            this.vRes = (PropertyResourceBundle)PropertyResourceBundle.getBundle("BrandingVersion");
        }
        catch (Exception e) {
            return;
        }
        this.product_name = this.fetch("product_name", this.product_name);
        this.abbrev_product_name = this.fetch("abbrev_product_name", this.abbrev_product_name);
        this.major_version = this.fetch("major_version", this.major_version);
        this.minor_version = this.fetch("minor_version", this.minor_version);
        this.update_version = this.fetch("update_version", this.update_version);
        this.build_id = this.fetch("build_id", this.build_id);
        this.version_prefix = this.fetch("version_prefix", this.version_prefix);
        this.version_suffix = this.fetch("version_suffix", this.version_suffix);
        String s = this.fetch("full_version", this.full_version);
        if (!s.equals(this.full_version)) {
            this.full_version = s;
            this.fullVersionSet = true;
        }
        if (!this.fullVersionSet && GlassFishBranding.ok(this.minor_version)) {
            try {
                if (Integer.parseInt(this.minor_version) > 0) {
                    if (this.update_version.length() > 0) {
                        if (Integer.parseInt(this.update_version) > 0) {
                            this.full_version = this.major_version + "." + this.minor_version + "." + this.update_version;
                        }
                    } else {
                        this.full_version = this.major_version + "." + this.minor_version;
                    }
                } else if (this.update_version.length() > 0) {
                    if (Integer.parseInt(this.update_version) > 0) {
                        this.full_version = this.major_version + "." + this.minor_version + "." + this.update_version;
                    }
                } else {
                    this.full_version = this.major_version;
                }
            }
            catch (NumberFormatException nfe) {
                this.full_version = this.major_version;
            }
        }
    }

    public String getVersion() {
        if (this.product_name == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.product_name);
        if (GlassFishBranding.ok(this.version_prefix)) {
            sb.append(" ").append(this.version_prefix);
        }
        if (this.full_version != null) {
            sb.append(" ").append(this.full_version);
        }
        if (GlassFishBranding.ok(this.version_suffix)) {
            sb.append(" ").append(this.version_suffix);
        }
        return sb.toString();
    }

    public String getFullVersion() {
        return this.getVersion() + " (build " + this.build_id + ")";
    }

    public String getAbbreviatedVersion() {
        return this.abbrev_product_name;
    }

    public String getMajorVersion() {
        return this.major_version;
    }

    public String getMinorVersion() {
        return this.minor_version;
    }

    public String getUpdateVersion() {
        return this.update_version;
    }

    public String getBuildVersion() {
        return this.build_id;
    }

    public String getVersionPrefix() {
        return this.version_prefix;
    }

    public String getVersionSuffix() {
        return this.version_suffix;
    }

    public String getProductName() {
        return this.product_name;
    }

    public String getAbbrevProductName() {
        return this.abbrev_product_name;
    }

    private String fetch(String name, String def) {
        if (this.vRes == null) {
            return def;
        }
        try {
            String s = this.vRes.getString(name);
            if (GlassFishBranding.ok(s)) {
                return s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

