/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourceUtil {
    private static final String DOMAIN = "domain";
    @Inject
    private Habitat habitat;
    @Inject
    private Domain domain;
    @Inject
    private ConfigBeansUtilities configBeanUtilities;

    public void createResourceRef(String jndiName, String enabled, String target) throws TransactionFailure {
        if (target.equals(DOMAIN)) {
            return;
        }
        if (this.domain.getConfigNamed(target) != null) {
            return;
        }
        Server server = ConfigBeansUtilities.getServerNamed((String)target);
        if (server != null) {
            if (!server.isResourceRefExists(jndiName)) {
                server.createResourceRef(enabled, jndiName);
            }
        } else {
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null && !cluster.isResourceRefExists(jndiName)) {
                cluster.createResourceRef(enabled, jndiName);
                Target tgt = (Target)this.habitat.getComponent(Target.class);
                List<Server> instances = tgt.getInstances(target);
                for (Server svr : instances) {
                    if (svr.isResourceRefExists(jndiName)) continue;
                    svr.createResourceRef(enabled, jndiName);
                }
            }
        }
    }

    public String computeEnabledValueForResourceBasedOnTarget(String enabledValue, String target) {
        String result = enabledValue;
        boolean enabled = Boolean.valueOf(enabledValue);
        if (!this.isNonResourceRefTarget(target) && !enabled) {
            result = Boolean.toString(!enabled);
        }
        return result;
    }

    private boolean isNonResourceRefTarget(String target) {
        boolean isNonResourceRefTarget = false;
        if (DOMAIN.equals(target)) {
            isNonResourceRefTarget = true;
        } else if (this.domain.getConfigNamed(target) != null) {
            isNonResourceRefTarget = true;
        }
        return isNonResourceRefTarget;
    }

    public boolean isResourceRefInTarget(String refName, String target) {
        Set<String> targets = this.getTargetsReferringResourceRef(refName);
        boolean resourceRefInTarget = false;
        for (String refTarget : targets) {
            if (!refTarget.equals(target)) continue;
            resourceRefInTarget = true;
            break;
        }
        return resourceRefInTarget;
    }

    public Set<String> getTargetsReferringResourceRef(String refName) {
        HashSet<String> targets = new HashSet<String>();
        List servers = this.domain.getServers().getServer();
        for (Server server : servers) {
            if (server.getResourceRef(refName) == null) continue;
            if (server.getCluster() != null) {
                targets.add(server.getCluster().getName());
                continue;
            }
            if (server.isDas()) {
                targets.add("server");
                continue;
            }
            if (!server.isInstance()) continue;
            targets.add(server.getName());
        }
        return targets;
    }

    public void deleteResourceRef(String jndiName, String target) throws TransactionFailure {
        if (target.equals(DOMAIN)) {
            return;
        }
        if (this.domain.getConfigNamed(target) != null) {
            return;
        }
        Server server = ConfigBeansUtilities.getServerNamed((String)target);
        if (server != null) {
            if (server.isResourceRefExists(jndiName)) {
                server.deleteResourceRef(jndiName);
            }
        } else {
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null && cluster.isResourceRefExists(jndiName)) {
                cluster.deleteResourceRef(jndiName);
                Target tgt = (Target)this.habitat.getComponent(Target.class);
                List<Server> instances = tgt.getInstances(target);
                for (Server svr : instances) {
                    if (!svr.isResourceRefExists(jndiName)) continue;
                    svr.deleteResourceRef(jndiName);
                }
            }
        }
    }
}

