/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameType {
    TEXT{

        public boolean accept(ByteBuffer buffer) {
            int curPosition = buffer.position();
            boolean acceptable = buffer.get() == 0;
            buffer.position(curPosition);
            return acceptable;
        }

        public byte[] unframe(ByteBuffer buffer) {
            ByteArrayOutputStream raw = new ByteArrayOutputStream();
            byte b = buffer.get();
            while (buffer.hasRemaining() && (b = buffer.get()) != -1) {
                raw.write(b);
            }
            if (b != -1) {
                throw new RuntimeException("Malformed frame.  Missing frame end delimiter: " + b);
            }
            return raw.toByteArray();
        }

        public byte[] frame(byte[] data) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 2);
            out.write(0);
            out.write(data, 0, data.length);
            out.write(-1);
            return out.toByteArray();
        }
    }
    ,
    CLOSING{

        public boolean accept(ByteBuffer buffer) {
            int curPosition = buffer.position();
            boolean acceptable = buffer.get() == -1 && buffer.get() == 0;
            buffer.position(curPosition);
            return acceptable;
        }

        public byte[] unframe(ByteBuffer buffer) throws IOException {
            return new byte[]{-1, 0};
        }

        public byte[] frame(byte[] data) {
            return new byte[]{-1, 0};
        }
    };


    public abstract boolean accept(ByteBuffer var1);

    public abstract byte[] unframe(ByteBuffer var1) throws IOException;

    public abstract byte[] frame(byte[] var1);

    public FrameType next() {
        FrameType[] types = FrameType.values();
        return this.ordinal() < types.length ? types[this.ordinal() + 1] : null;
    }
}

