/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="postcreateapplicationref")
@Supplemental(value="create-application-ref", ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class PostCreateApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PostCreateApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Inject
    private Deployment deployment;
    @Inject
    private Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        DeployCommandSupplementalInfo suppInfo = (DeployCommandSupplementalInfo)context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        if (suppInfo.isAppRefExists()) {
            report.setMessage(localStrings.getLocalString("appref.already.exists", "Application reference {0} already exists in target {1}.", new Object[]{this.name, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            return;
        }
        DeploymentContext dc = suppInfo.deploymentContext();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (params.target.equals("server")) {
            return;
        }
        try {
            ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap(dc);
            ArrayList<String> targets = new ArrayList<String>(Arrays.asList(params.target.split(",")));
            ActionReport.ExitCode replicateResult = ClusterOperationUtil.replicateCommand((String)"_deploy", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Ignore, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
            report.setActionExitCode(replicateResult);
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
    }
}

