/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-message-security-provider")
@Scoped(value=PerLookup.class)
@I18n(value="create.message.security.provider")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateMessageSecurityProvider
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateMessageSecurityProvider.class);
    private static final String SERVER = "server";
    private static final String CLIENT = "client";
    private static final String CLIENT_SERVER = "client-server";
    @Param(name="layer", acceptableValues="SOAP,HttpServlet", defaultValue="SOAP")
    String authLayer;
    @Param(name="providertype", acceptableValues="client,server,client-server", optional=true, defaultValue="client-server")
    String providerType;
    @Param(name="requestauthsource", optional=true)
    String requestAuthSource;
    @Param(name="requestauthrecipient", optional=true)
    String requestAuthRecipient;
    @Param(name="responseauthsource", optional=true)
    String responseAuthSource;
    @Param(name="responseauthrecipient", optional=true)
    String responseAuthRecipient;
    @Param(name="isdefaultprovider", optional=true, defaultValue="false")
    Boolean isDefaultProvider;
    @Param(optional=true, name="property", separator=58)
    Properties properties;
    @Param(name="classname")
    String providerClass;
    @Param(name="providername", primary=true)
    String providerId;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        com.sun.enterprise.config.serverbeans.Cluster cluster;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        SecurityService secService = this.config.getSecurityService();
        List mscs = secService.getMessageSecurityConfig();
        MessageSecurityConfig msgSecCfg = null;
        for (MessageSecurityConfig msc : mscs) {
            if (!msc.getAuthLayer().equals(this.authLayer)) continue;
            msgSecCfg = msc;
        }
        if (msgSecCfg != null) {
            List pcs = msgSecCfg.getProviderConfig();
            for (ProviderConfig pc : pcs) {
                if (!pc.getProviderId().equals(this.providerId)) continue;
                report.setMessage(localStrings.getLocalString("create.message.security.provider.duplicatefound", "Message security provider named {0} exists. Cannot add duplicate.", new Object[]{this.providerId}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                ConfigSupport.apply(new SingleConfigCode<MessageSecurityConfig>(){

                    @Override
                    public Object run(MessageSecurityConfig param) throws PropertyVetoException, TransactionFailure {
                        ProviderConfig newPC = (ProviderConfig)param.createChild(ProviderConfig.class);
                        CreateMessageSecurityProvider.this.populateProviderConfigElement(newPC);
                        param.getProviderConfig().add(newPC);
                        if (CreateMessageSecurityProvider.this.isDefaultProvider.booleanValue()) {
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.SERVER) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                param.setDefaultProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                param.setDefaultClientProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                        }
                        return newPC;
                    }
                }, msgSecCfg);
            }
            catch (TransactionFailure e) {
                report.setMessage(localStrings.getLocalString("create.message.security.provider.fail", "Creation of message security provider named {0} failed", new Object[]{this.providerId}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(localStrings.getLocalString("create.message.security.provider.success", "Creation of message security provider named {0} completed successfully", new Object[]{this.providerId}));
        } else {
            try {
                ConfigSupport.apply(new SingleConfigCode<SecurityService>(){

                    @Override
                    public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                        MessageSecurityConfig newMSC = (MessageSecurityConfig)param.createChild(MessageSecurityConfig.class);
                        newMSC.setAuthLayer(CreateMessageSecurityProvider.this.authLayer);
                        param.getMessageSecurityConfig().add(newMSC);
                        ProviderConfig newPC = (ProviderConfig)newMSC.createChild(ProviderConfig.class);
                        CreateMessageSecurityProvider.this.populateProviderConfigElement(newPC);
                        newMSC.getProviderConfig().add(newPC);
                        if (CreateMessageSecurityProvider.this.isDefaultProvider.booleanValue()) {
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.SERVER) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                newMSC.setDefaultProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                            if (CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT) || CreateMessageSecurityProvider.this.providerType.equals(CreateMessageSecurityProvider.CLIENT_SERVER)) {
                                newMSC.setDefaultClientProvider(CreateMessageSecurityProvider.this.providerId);
                            }
                        }
                        return newMSC;
                    }
                }, secService);
            }
            catch (TransactionFailure e) {
                report.setMessage(localStrings.getLocalString("create.message.security.provider.fail", "Creation of message security provider named {0} failed", new Object[]{this.providerId}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(localStrings.getLocalString("create.message.security.provider.success", "Creation of message security provider named {0} completed successfully", new Object[]{this.providerId}));
        }
    }

    private void populateProviderConfigElement(ProviderConfig newProviderConfig) throws PropertyVetoException, TransactionFailure {
        newProviderConfig.setClassName(this.providerClass);
        newProviderConfig.setProviderId(this.providerId);
        newProviderConfig.setProviderType(this.providerType);
        RequestPolicy reqPolicy = (RequestPolicy)newProviderConfig.createChild(RequestPolicy.class);
        reqPolicy.setAuthSource(this.requestAuthSource);
        reqPolicy.setAuthRecipient(this.requestAuthRecipient);
        newProviderConfig.setRequestPolicy(reqPolicy);
        ResponsePolicy respPolicy = (ResponsePolicy)newProviderConfig.createChild(ResponsePolicy.class);
        respPolicy.setAuthSource(this.responseAuthSource);
        respPolicy.setAuthRecipient(this.responseAuthRecipient);
        newProviderConfig.setResponsePolicy(respPolicy);
        if (this.properties != null) {
            for (Object propname : this.properties.keySet()) {
                Property newprop = (Property)newProviderConfig.createChild(Property.class);
                newprop.setName((String)propname);
                newprop.setValue(this.properties.getProperty((String)propname));
                newProviderConfig.getProperty().add(newprop);
            }
        }
    }
}

