/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.StopDomainCommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-domain")
@Scoped(value=PerLookup.class)
public class RestartDomainCommand
extends StopDomainCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Inject
    private Habitat habitat;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartDomainCommand.class);

    protected void doCommand() throws CommandException, CommandValidationException {
        long uptimeOldServer = this.getUptime();
        RemoteCommand cmd = new RemoteCommand("restart-domain", this.programOpts, this.env);
        String oldpw = this.programOpts.getPassword();
        File pwFile = this.getServerDirs().getLocalPasswordFile();
        long stamp = -1L;
        if (pwFile != null) {
            stamp = pwFile.lastModified();
        }
        if (this.debug != null) {
            cmd.executeAndReturnOutput("restart-domain", "--debug", this.debug.toString());
        } else {
            cmd.executeAndReturnOutput("restart-domain");
        }
        this.waitForRestart(pwFile, stamp, uptimeOldServer);
        logger.printMessage(strings.get("restartDomain.success"));
    }

    protected int dasNotRunning() throws CommandException, CommandValidationException {
        logger.printWarning(strings.get("restart.dasNotRunning"));
        CLICommand cmd = (CLICommand)this.habitat.getComponent(CLICommand.class, "start-domain");
        return cmd.execute(this.argv);
    }
}

