/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.glassfish.api.admin.CommandException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartServerHelper {
    private final boolean terse;
    private final GFLauncher launcher;
    private final CLILogger logger;
    private final File pidFile;
    private final GFLauncherInfo info;
    private final Set<Integer> ports;
    private final ServerDirs serverDirs;
    private final String masterPassword;
    private final boolean debug;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartServerHelper.class);

    public StartServerHelper(CLILogger logger0, boolean terse0, ServerDirs serverDirs0, GFLauncher launcher0, String masterPassword0, boolean debug0) {
        this.logger = logger0;
        this.terse = terse0;
        this.launcher = launcher0;
        this.info = this.launcher.getInfo();
        this.ports = this.info.getAdminPorts();
        this.serverDirs = serverDirs0;
        this.pidFile = this.serverDirs.getPidFile();
        this.masterPassword = masterPassword0;
        this.debug = debug0;
    }

    public void waitForServer() throws CommandException {
        long startWait = System.currentTimeMillis();
        if (!this.terse) {
            System.out.print(strings.get("WaitServer") + " ");
        }
        boolean alive = false;
        int count = 0;
        block5: while (!this.timedOut(startWait)) {
            if (this.pidFile != null) {
                this.logger.printDebugMessage("Check for pid file: " + this.pidFile);
                if (this.pidFile.exists()) {
                    alive = true;
                    break;
                }
            } else {
                for (int port : this.ports) {
                    if (!NetUtils.isRunning((int)port)) continue;
                    alive = true;
                    break block5;
                }
            }
            try {
                Process p = this.launcher.getProcess();
                int exitCode = p.exitValue();
                ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
                String output = psd.getOutErrString();
                if (StringUtils.ok((String)output)) {
                    throw new CommandException(strings.get("dasDiedOutput", new Object[]{this.info.getDomainName(), exitCode, output}));
                }
                throw new CommandException(strings.get("dasDied", new Object[]{this.info.getDomainName(), exitCode}));
            }
            catch (GFLauncherException ex) {
            }
            catch (IllegalThreadStateException ex) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
                if (this.terse || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.terse) {
            System.out.println();
        }
        if (!alive) {
            String msg = strings.get("dasNoStart", new Object[]{this.info.getDomainName(), 600L});
            throw new CommandException(msg);
        }
    }

    public boolean prepareForLaunch() throws CommandException {
        this.waitForParentToDie();
        this.setSecurity();
        if (!this.checkPorts()) {
            return false;
        }
        this.deletePidFile();
        return true;
    }

    public void report() {
        String logfile;
        try {
            logfile = this.launcher.getLogFilename();
        }
        catch (GFLauncherException ex) {
            logfile = "UNKNOWN";
        }
        int adminPort = -1;
        String adminPortString = "-1";
        try {
            adminPort = this.info.getAnAdminPort();
            adminPortString = "" + adminPort;
        }
        catch (Exception e) {
            // empty catch block
        }
        int debugPort = -1;
        String debugPortString = "-1";
        if (this.debug) {
            debugPort = this.launcher.getDebugPort();
            debugPortString = "" + debugPort;
        }
        this.logger.printMessage(strings.get("ServerStart.SuccessMessage", new Object[]{this.info.isDomain() ? "domain " : "instance", this.serverDirs.getServerName(), this.serverDirs.getServerDir(), logfile, adminPortString}));
        if (debugPort >= 0) {
            this.logger.printMessage(strings.get("ServerStart.DebuggerMessage", new Object[]{debugPortString}));
        }
    }

    private void waitForParentToDie() throws CommandException {
        if (Boolean.getBoolean("AS_RESTART")) {
            new ParentDeathWaiter();
        }
    }

    private boolean checkPorts() {
        String err = this.adminPortInUse();
        if (err != null) {
            this.logger.printWarning(err);
            return false;
        }
        return true;
    }

    private void deletePidFile() {
        String msg = this.serverDirs.deletePidFile();
        if (msg != null) {
            this.logger.printDebugMessage(msg);
        }
    }

    private void setSecurity() {
        this.info.addSecurityToken("AS_ADMIN_MASTERPASSWORD", this.masterPassword);
    }

    private String adminPortInUse() {
        Set adminPorts = this.info.getAdminPorts();
        return this.adminPortInUse(adminPorts);
    }

    private String adminPortInUse(Set<Integer> adminPorts) {
        for (Integer port : adminPorts) {
            if (NetUtils.isPortFree((int)port)) continue;
            return strings.get("ServerRunning", new Object[]{port.toString()});
        }
        return null;
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 600000L;
    }

    private class ParentDeathWaiter
    implements Runnable {
        boolean success = false;

        public void run() {
            try {
                while (System.in.read() >= 0) {
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            Set adminPorts = StartServerHelper.this.info.getAdminPorts();
            while (StartServerHelper.this.adminPortInUse(adminPorts) != null) {
            }
            this.success = true;
        }

        private ParentDeathWaiter() throws CommandException {
            try {
                Thread t = new Thread(this);
                t.start();
                t.join(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.success) {
                throw new CommandException(strings.get("deathwait_timeout", new Object[]{60000}));
            }
        }
    }
}

