/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.component.Wombs;
import org.jvnet.hk2.junit.Hk2RunnerOptions;
import org.jvnet.hk2.junit.Hk2TestServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hk2Runner
extends Runner {
    final Class<?> testClass;
    final Description description;
    final Map<Description, Method> testMethods = new LinkedHashMap<Description, Method>();
    private Object instance;
    static Hk2TestServices singleton;

    public Hk2Runner(Class<?> testClass) {
        this.testClass = testClass;
        this.description = Description.createSuiteDescription(testClass);
        for (Method m : testClass.getDeclaredMethods()) {
            if (m.getAnnotation(Test.class) == null) continue;
            Description testDescription = Description.createTestDescription(testClass, (String)m.getName());
            this.description.addChild(testDescription);
            this.testMethods.put(testDescription, m);
        }
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        Failure failure;
        if (this.testClass.isAnnotationPresent(Ignore.class)) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        for (Method m : this.testClass.getMethods()) {
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(BeforeClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
        }
        Hk2RunnerOptions options = this.testClass.getAnnotation(Hk2RunnerOptions.class);
        boolean reinitPerTest = null != options ? options.reinitializePerTest() : false;
        try {
            this.wombInit();
        }
        catch (ComponentException e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            return;
        }
        for (Description testDescription : this.description.getChildren()) {
            Method m = this.testMethods.get(testDescription);
            if (m.isAnnotationPresent(Ignore.class)) {
                notifier.fireTestIgnored(testDescription);
                continue;
            }
            notifier.fireTestStarted(testDescription);
            try {
                m.invoke(this.instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(testDescription, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(testDescription, e.getTargetException());
                notifier.fireTestFailure(failure);
            }
            notifier.fireTestFinished(testDescription);
            if (!reinitPerTest) continue;
            try {
                this.wombInit();
            }
            catch (ComponentException e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
                return;
            }
        }
        for (Method m : this.testClass.getMethods()) {
            Failure failure2;
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(AfterClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure2 = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure2);
            }
            catch (InvocationTargetException e) {
                failure2 = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure2);
            }
        }
    }

    public static Habitat getHabitat() {
        return singleton.getHabitat();
    }

    private void wombInit() {
        singleton = new Hk2TestServices();
        Habitat habitat = singleton.getHabitat();
        Womb<?> womb = Wombs.create(this.testClass, habitat, new MultiMap<String, String>());
        this.instance = womb.get();
    }
}

