/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsScanner;
import com.sun.hk2.component.IntrospectionScanner;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class Hk2TestServices {
    private Habitat habitat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hk2TestServices() {
        System.out.println("Singleton created");
        String classPath = System.getProperty("surefire.test.class.path");
        if (classPath == null) {
            classPath = System.getProperty("java.class.path");
        }
        System.out.println("classpath is " + classPath);
        ParsingContext.Builder builder = new ParsingContext.Builder();
        final HashSet<String> annotations = new HashSet<String>();
        annotations.add("org.jvnet.hk2.annotations.Contract");
        annotations.add("org.jvnet.hk2.annotations.Service");
        builder.config(new ParsingConfig(){
            final Set<String> empty = Collections.emptySet();

            @Override
            public Set<String> getInjectionTargetAnnotations() {
                return this.empty;
            }

            @Override
            public Set<String> getInjectionTargetInterfaces() {
                return annotations;
            }

            @Override
            public Set<String> getInjectionPointsAnnotations() {
                return this.empty;
            }
        });
        ParsingContext context = null;
        try {
            context = builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Parser parser = new Parser(context);
        final ClassLoader cLoader = this.getClass().getClassLoader();
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            @Override
            public ClassLoader get() {
                return cLoader;
            }
        };
        this.habitat = new Habitat();
        ArrayList<InhabitantsScanner> metaInfScanners = new ArrayList<InhabitantsScanner>();
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreElements()) {
            String fileName = st.nextToken();
            File f = new File(fileName);
            if (!f.exists()) continue;
            try {
                System.out.println("Beginning parsing " + fileName);
                if (f.isFile()) {
                    JarFile jarFile = new JarFile(f);
                    JarEntry entry = jarFile.getJarEntry("META-INF/inhabitants/default");
                    if (entry != null) {
                        byte[] buf = new byte[(int)entry.getSize()];
                        DataInputStream in = new DataInputStream(jarFile.getInputStream(entry));
                        try {
                            in.readFully(buf);
                        }
                        finally {
                            in.close();
                        }
                        System.out.println("Using meta-inf file for " + f.getPath());
                        metaInfScanners.add(new InhabitantsScanner(new ByteArrayInputStream(buf), "jar:" + f.toURL() + "!/" + entry.getName()));
                    } else {
                        this.parse(parser, f);
                    }
                    jarFile.close();
                    continue;
                }
                File inhabitantFile = new File(f, "META-INF/inhabitants" + File.separator + "default");
                if (inhabitantFile.exists()) {
                    System.out.println("Using meta-inf file for " + f.getPath());
                    metaInfScanners.add(new InhabitantsScanner(new BufferedInputStream(new FileInputStream(inhabitantFile)), inhabitantFile.getPath()));
                    continue;
                }
                this.parse(parser, f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            parser.awaitTermination();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Starting to introspect");
        InhabitantsParser ip = new InhabitantsParser(this.habitat);
        IntrospectionScanner is = new IntrospectionScanner(context);
        try {
            ip.parse(is, holder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("finished introspecting");
        System.out.println("Starting to introspect");
        for (InhabitantsScanner scanner : metaInfScanners) {
            try {
                ip.parse(scanner, holder);
                scanner.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        System.out.println("finished introspecting");
        Iterator<String> contracts = this.habitat.getAllContracts();
        while (contracts.hasNext()) {
            String contract = contracts.next();
            System.out.println("Found contract : " + contract);
            for (Inhabitant<?> t : this.habitat.getInhabitantsByContract(contract)) {
                System.out.println(" --> " + t.typeName() + " " + t.metadata());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Parser parser, final File f) throws IOException {
        String imports;
        Manifest manifest = null;
        if (f.isDirectory()) {
            File manifestFile = new File(f, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifestFile));
                try {
                    manifest = new Manifest(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        } else {
            JarFile jar = new JarFile(f);
            manifest = jar.getManifest();
            jar.close();
        }
        if (manifest != null && ((imports = manifest.getMainAttributes().getValue("Import-Package")) == null || imports.indexOf("hk2") == -1)) {
            System.out.println("Ignoring service-less " + f.getName());
            return;
        }
        parser.parse(f, new Runnable(){

            public void run() {
                System.out.println("Finished introspecting " + f.getName());
            }
        });
    }

    public Habitat getHabitat() {
        return this.habitat;
    }
}

