/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWebSocket
implements WebSocket {
    private NetworkHandler networkHandler;
    protected static final Logger logger = Logger.getLogger("websocket");
    private final Set<WebSocketListener> listeners = new LinkedHashSet<WebSocketListener>();
    private final AtomicBoolean connected = new AtomicBoolean(false);

    public BaseWebSocket(NetworkHandler handler, WebSocketListener ... listeners) {
        this.networkHandler = handler;
        handler.setWebSocket(this);
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
    }

    public NetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    public Set<WebSocketListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void close() throws IOException {
        if (this.connected.compareAndSet(true, false)) {
            this.onClose();
            this.listeners.clear();
        }
    }

    @Override
    public void onClose() throws IOException {
        for (WebSocketListener listener : this.listeners) {
            listener.onClose(this);
        }
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void send(String data) throws IOException {
        this.send(new DataFrame(data));
    }

    @Override
    public void send(DataFrame frame) throws IOException {
        this.networkHandler.send(frame);
    }

    @Override
    public void onConnect() throws IOException {
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
        this.connected.compareAndSet(false, true);
    }

    @Override
    public void onMessage(DataFrame frame) throws IOException {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage(this, frame);
        }
    }
}

