/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.List;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.PropertyResolver;
import org.jvnet.hk2.config.Dom;

public class ServerHelper {
    private final Server server;
    private final Config config;

    public ServerHelper(Server theServer, Config theConfig) {
        this.server = theServer;
        this.config = theConfig;
        if (this.server == null || this.config == null) {
            throw new IllegalArgumentException();
        }
    }

    public final int getAdminPort() {
        try {
            if (this.server == null) {
                return -1;
            }
            if (this.config == null) {
                return -1;
            }
            String portString = this.getAdminPortString(this.server, this.config);
            if (portString == null) {
                return -1;
            }
            return Integer.parseInt(portString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public final String getHost() {
        if (this.server.isDas()) {
            return null;
        }
        String hostName = null;
        Dom serverDom = Dom.unwrap(this.server);
        Nodes nodes = serverDom.getHabitat().getComponent(Nodes.class);
        if (this.server == null || nodes == null) {
            return null;
        }
        String nodeName = this.server.getNode();
        if (StringUtils.ok((String)nodeName)) {
            Node node = nodes.getNode(nodeName);
            if (node != null) {
                hostName = node.getNodeHost();
            }
            if (hostName == null && nodeName.equals("localhost")) {
                hostName = "localhost";
            }
        }
        if (StringUtils.ok(hostName)) {
            return hostName;
        }
        return null;
    }

    public final boolean isRunning() {
        try {
            return NetUtils.isRunning((String)this.getHost(), (int)this.getAdminPort());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getAdminPortString(Server server, Config config) {
        if (server == null || config == null) {
            return null;
        }
        try {
            List listeners = config.getNetworkConfig().getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : listeners) {
                if (!"admin-listener".equals(listener.getProtocol())) continue;
                return this.translatePort(listener, server, config);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String translatePort(NetworkListener adminListener, Server server, Config config) {
        NetworkListener adminListenerRaw = null;
        try {
            Dom serverDom = Dom.unwrap(server);
            Domain domain = serverDom.getHabitat().getComponent(Domain.class);
            adminListenerRaw = GlassFishConfigBean.getRawView(adminListener);
            String portString = adminListenerRaw.getPort();
            if (!ServerHelper.isToken(portString)) {
                return portString;
            }
            PropertyResolver resolver = new PropertyResolver(domain, server.getName());
            return resolver.getPropertyValue(portString);
        }
        catch (ClassCastException e) {
            return this.translatePortOld(adminListener.getPort(), server, config);
        }
    }

    private String translatePortOld(String portString, Server server, Config config) {
        if (!ServerHelper.isToken(portString)) {
            return portString;
        }
        String key = portString.substring(2, portString.length() - 1);
        SystemProperty prop = server.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        prop = config.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    private static boolean isToken(String s) {
        return s != null && s.startsWith("${") && s.endsWith("}") && s.length() > 3;
    }
}

