/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketApplication
implements WebSocketListener {
    private final Set<WebSocket> sockets = new HashSet<WebSocket>();
    private final Set<WebSocketListener> listeners = new HashSet<WebSocketListener>();
    private final ReentrantReadWriteLock socketsLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<WebSocket> getWebSockets() {
        this.socketsLock.readLock().lock();
        try {
            Set<WebSocket> set = Collections.unmodifiableSet(this.sockets);
            return set;
        }
        finally {
            this.socketsLock.readLock().unlock();
        }
    }

    protected boolean add(WebSocket socket) {
        this.socketsLock.writeLock().lock();
        try {
            boolean bl = this.sockets.add(socket);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.socketsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(WebSocket socket) {
        this.socketsLock.writeLock().lock();
        try {
            boolean bl = this.sockets.remove(socket);
            return bl;
        }
        finally {
            this.socketsLock.writeLock().unlock();
        }
    }

    public WebSocket createSocket(NetworkHandler handler, WebSocketListener ... listeners) throws IOException {
        return new BaseServerWebSocket(handler, listeners);
    }

    @Override
    public void onClose(WebSocket socket) throws IOException {
        this.remove(socket);
        socket.close();
    }

    @Override
    public void onConnect(WebSocket socket) {
        this.add(socket);
    }

    @Override
    public void onMessage(WebSocket socket, DataFrame data) throws IOException {
    }
}

