/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.SecKey;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketCloseHandler;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketEngine {
    public static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SEC_WS_KEY1_HEADER = "Sec-WebSocket-Key1";
    public static final String SEC_WS_KEY2_HEADER = "Sec-WebSocket-Key2";
    public static final String CLIENT_WS_ORIGIN_HEADER = "Origin";
    public static final String SERVER_SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String SERVER_SEC_WS_LOCATION_HEADER = "Sec-WebSocket-Location";
    public static final String WEBSOCKET = "websocket";
    static final Logger logger = Logger.getLogger("websocket");
    private static final WebSocketEngine engine = new WebSocketEngine();
    private final Map<String, WebSocketApplication> applications = new HashMap<String, WebSocketApplication>();
    static final int INITIAL_BUFFER_SIZE = 8192;
    private final WebSocketCloseHandler closeHandler = new WebSocketCloseHandler();

    private WebSocketEngine() {
        SecKey.init();
    }

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public WebSocketApplication getApplication(String uri) {
        return this.applications.get(uri);
    }

    public boolean handle(AsyncExecutor asyncExecutor) {
        WebSocket socket = null;
        try {
            Request request = asyncExecutor.getProcessorTask().getRequest();
            if ("WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
                socket = this.getWebSocket(asyncExecutor, request);
            }
        }
        catch (IOException e) {
            return false;
        }
        return socket != null;
    }

    protected WebSocket getWebSocket(AsyncExecutor asyncExecutor, Request request) throws IOException {
        WebSocketApplication app = WebSocketEngine.getEngine().getApplication(request.requestURI().toString());
        BaseServerWebSocket socket = null;
        try {
            if (app != null) {
                Response response = request.getResponse();
                ProcessorTask task = asyncExecutor.getProcessorTask();
                AsyncProcessorTask asyncTask = (AsyncProcessorTask)asyncExecutor.getAsyncTask();
                SelectionKey key = task.getSelectionKey();
                ServerNetworkHandler handler = new ServerNetworkHandler(task, asyncTask, request, response);
                ((BaseSelectionKeyHandler)task.getSelectorHandler().getSelectionKeyHandler()).setConnectionCloseHandler((ConnectionCloseHandler)this.closeHandler);
                socket = (BaseServerWebSocket)app.createSocket(handler, app, new KeyWebSocketListener(key));
                handler.handshake(task.getSSLSupport() != null);
                this.enableRead(task, key);
                key.attach(handler.getAttachment());
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            socket = null;
        }
        catch (HandshakeException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            socket = null;
        }
        return socket;
    }

    final void enableRead(ProcessorTask task, SelectionKey key) {
        task.getSelectorHandler().register(key, 1);
    }

    public void register(String name, WebSocketApplication app) {
        this.applications.put(name, app);
    }

    private static class KeyWebSocketListener
    implements WebSocketListener {
        private final SelectionKey key;

        public KeyWebSocketListener(SelectionKey key) {
            this.key = key;
        }

        public void onClose(WebSocket socket) throws IOException {
            this.key.cancel();
            this.key.channel().close();
        }

        public void onConnect(WebSocket socket) {
        }

        public void onMessage(WebSocket socket, DataFrame frame) throws IOException {
        }
    }
}

