/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

public class WebSocketSelectionKeyAttachment
extends SelectedKeyAttachmentLogic
implements Runnable {
    private final ServerNetworkHandler handler;
    private final ProcessorTask processorTask;
    private final AsyncProcessorTask asyncProcessorTask;

    public WebSocketSelectionKeyAttachment(ServerNetworkHandler snh, ProcessorTask task, AsyncProcessorTask asyncTask) {
        this.handler = snh;
        this.processorTask = task;
        this.asyncProcessorTask = asyncTask;
        SelectionKey selectionKey = this.asyncProcessorTask.getAsyncExecutor().getProcessorTask().getSelectionKey();
    }

    public boolean timedOut(SelectionKey key) {
        return false;
    }

    public void handleSelectedKey(SelectionKey key) {
        if (key.isReadable()) {
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
            this.asyncProcessorTask.getThreadPool().execute(this);
        }
    }

    public void run() {
        try {
            this.handler.readFrame();
            this.enableRead(this.processorTask, this.getSelectionKey());
        }
        catch (IOException e) {
            this.processorTask.setAptCancelKey(true);
            this.processorTask.terminateProcess();
            WebSocketEngine.logger.log(Level.INFO, e.getMessage(), e);
        }
    }

    final void enableRead(ProcessorTask task, SelectionKey key) {
        task.getSelectorHandler().register(key, 1);
    }

    public SelectionKey getSelectionKey() {
        return this.asyncProcessorTask.getAsyncExecutor().getProcessorTask().getSelectionKey();
    }

    public ServerNetworkHandler getHandler() {
        return this.handler;
    }
}

