/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.experimentalgfapi;

import java.util.Properties;
import java.util.ServiceLoader;
import org.glassfish.experimentalgfapi.Constants;
import org.glassfish.experimentalgfapi.GlassFish;

public abstract class GlassFishRuntime {
    private static GlassFishRuntime me;
    private static RuntimeBuilder runtimeBuilder;

    public static synchronized GlassFishRuntime bootstrap(Properties properties, ClassLoader cl) throws Exception {
        if (me != null) {
            return me;
        }
        Constants.Platform platform = GlassFishRuntime.whichPlatform(properties);
        runtimeBuilder = GlassFishRuntime.getRuntimeBuilder(platform, cl != null ? cl : GlassFishRuntime.class.getClassLoader());
        me = runtimeBuilder.build(properties);
        return me;
    }

    public static synchronized void shutdown() throws Exception {
        runtimeBuilder.destroy();
        me = null;
    }

    public static synchronized GlassFishRuntime get() {
        if (me == null) {
            throw new RuntimeException("Not yet bootstrapped");
        }
        return me;
    }

    public abstract GlassFish newGlassFish(Properties var1) throws Exception;

    private static Constants.Platform whichPlatform(Properties properties) {
        return Constants.Platform.valueOf(properties.getProperty("GlassFish_Platform"));
    }

    private static RuntimeBuilder getRuntimeBuilder(Constants.Platform platform, ClassLoader cl) {
        ServiceLoader<RuntimeBuilder> runtimeBuilders = ServiceLoader.load(RuntimeBuilder.class, cl);
        for (RuntimeBuilder builder : runtimeBuilders) {
            if (!builder.handles(platform)) continue;
            return builder;
        }
        throw new RuntimeException("No runtime builder for platform: " + (Object)((Object)platform));
    }

    public static interface RuntimeBuilder {
        public GlassFishRuntime build(Properties var1) throws Exception;

        public boolean handles(Constants.Platform var1);

        public void destroy() throws Exception;
    }
}

