/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.AppServerStartup;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.ReadableArchiveScannerAdapter;
import com.sun.enterprise.v3.server.SnifferManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.VersioningDeploymentSyntaxException;
import org.glassfish.deployment.common.VersioningDeploymentUtil;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ApplicationLifecycle
implements Deployment {
    @Inject
    protected SnifferManagerImpl snifferManager;
    @Inject
    Habitat habitat;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    protected Applications applications;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    protected Domain domain;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Events events;
    @Inject
    ConfigSupport configSupport;
    protected Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);

    protected <T extends Container, U extends ApplicationContainer> Deployer<T, U> getDeployer(EngineInfo<T, U> engineInfo) {
        return engineInfo.getDeployer();
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        for (CompositeHandler handler : this.habitat.getAllByContract(CompositeHandler.class)) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        LinkedList<ArchiveHandler> handlerList = new LinkedList<ArchiveHandler>();
        for (ArchiveHandler handler : this.habitat.getAllByContract(ArchiveHandler.class)) {
            if (handler instanceof CompositeHandler || "DEFAULT".equals(handler.getClass().getAnnotation(Service.class).name())) continue;
            if ("connector".equals(handler.getClass().getAnnotation(Service.class).name())) {
                handlerList.addLast(handler);
                continue;
            }
            handlerList.addFirst(handler);
        }
        for (ArchiveHandler handler : handlerList) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        return (ArchiveHandler)this.habitat.getComponent(ArchiveHandler.class, "DEFAULT");
    }

    public ApplicationInfo deploy(ExtendedDeploymentContext context) {
        return this.deploy(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationInfo deploy(Collection<Sniffer> sniffers, final ExtendedDeploymentContext context) {
        this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_START, context));
        report = context.getActionReport();
        commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        appName = commandParams.name();
        if (commandParams.origin == OpsParams.Origin.deploy && this.appRegistry.get(appName) != null) {
            report.setMessage(ApplicationLifecycle.localStrings.getLocalString("appnamenotunique", "Application name {0} is already in use. Please pick a different name.", new Object[]{appName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        if (commandParams.virtualservers == null) {
            commandParams.virtualservers = this.getVirtualServers(commandParams.target);
        }
        tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                ApplicationLifecycle.this.appRegistry.remove(appName);
                for (EngineRef module : this.get("started", EngineRef.class)) {
                    module.stop((ApplicationContext)context);
                }
                try {
                    ((PreDestroy)PreDestroy.class.cast(context)).preDestroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (EngineRef module : this.get("loaded", EngineRef.class)) {
                    module.unload(context);
                }
                for (EngineRef module : this.get("prepared", EngineRef.class)) {
                    module.clean(context);
                }
                if (!commandParams.keepfailedstubs.booleanValue()) {
                    context.clean();
                }
            }
        };
        context.addTransientAppMetaData("tracker", (Object)tracker);
        context.setPhase(ExtendedDeploymentContext.Phase.PREPARE);
        appInfo = null;
        handler = context.getArchiveHandler();
        if (handler == null) {
            handler = this.getArchiveHandler(context.getSource());
            context.setArchiveHandler(handler);
        }
        if (handler == null) {
            report.setMessage(ApplicationLifecycle.localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{context.getSourceDir()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            var9_10 = null;
            if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                this.events.send(new EventListener.Event<Object>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                return var9_10;
            }
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
            return var9_10;
        }
        {
            catch (Exception e) {
                e.printStackTrace();
                report.failure(this.logger, "Exception while deploying the app", e);
                tracker.actOn(this.logger);
                return null;
            }
            catch (Throwable var21_26) {
                throw var21_26;
            }
            clh = (ClassLoaderHierarchy)this.habitat.getByContract(ClassLoaderHierarchy.class);
            context.createDeploymentClassLoader(clh, handler);
            scannerAdapter = new ReadableArchiveScannerAdapter(context.getSource());
            parsingContext = new ParsingContext.Builder().logger(context.getLogger()).build();
            parser = new Parser(parsingContext);
            parser.parse((ArchiveAdapter)scannerAdapter, null);
            parser.awaitTermination();
            context.addModuleMetaData((Object)parsingContext.getTypes());
            context.addModuleMetaData((Object)parser);
            cloader = context.getClassLoader();
            currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(cloader);
                if (sniffers != null && this.logger.isLoggable(Level.FINE)) {
                    for (Sniffer sniffer : sniffers) {
                        this.logger.fine("Before Sorting" + sniffer.getModuleType());
                    }
                }
                sortedEngineInfos = this.setupContainerInfos(handler, sniffers, (DeploymentContext)context);
                if (this.logger.isLoggable(Level.FINE)) {
                    for (EngineInfo info : sortedEngineInfos) {
                        this.logger.fine("After Sorting " + info.getSniffer().getModuleType());
                    }
                }
                if (sortedEngineInfos == null || sortedEngineInfos.isEmpty()) {
                    report.failure(this.logger, ApplicationLifecycle.localStrings.getLocalString("unknowncontainertype", "There is no installed container capable of handling this application {0}", new Object[]{context.getSource().getName()}));
                    tracker.actOn(this.logger);
                    i$ = null;
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        this.events.send(new EventListener.Event<Object>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                        return i$;
                    }
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    return i$;
                }
            }
            catch (Throwable var20_25) {}
            {
                Thread.currentThread().setContextClassLoader(currentCL);
                throw var20_25;
            }
        }
        {
            tempAppInfo = new ApplicationInfo(this.events, context.getSource(), appName);
            for (E m : context.getModuleMetadata()) {
                tempAppInfo.addMetaData(m);
            }
            tempAppInfo.setIsJavaEEApp(sortedEngineInfos);
            this.appRegistry.add(appName, tempAppInfo);
            context.createApplicationClassLoader(clh, handler);
            moduleInfo = null;
            try {
                moduleInfo = this.prepareModule(sortedEngineInfos, appName, (DeploymentContext)context, tracker);
            }
            catch (Exception prepareException) {
                report.failure(this.logger, "Exception while preparing the app", prepareException);
                tracker.actOn(this.logger);
                var19_23 = null;
                Thread.currentThread().setContextClassLoader(currentCL);
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                    return var19_23;
                }
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                return var19_23;
            }
        }
        {
            appInfo = (ApplicationInfo)context.getModuleMetaData(ApplicationInfo.class);
            if (appInfo == null) {
                appInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                appInfo.addModule(moduleInfo);
                for (E m : context.getModuleMetadata()) {
                    moduleInfo.addMetaData(m);
                    appInfo.addMetaData(m);
                }
            } else {
                for (EngineRef ref : moduleInfo.getEngineRefs()) {
                    appInfo.add(ref);
                }
            }
            this.appRegistry.remove(appName);
            appInfo.setIsJavaEEApp(sortedEngineInfos);
            this.appRegistry.add(appName, appInfo);
            context.setPhase(ExtendedDeploymentContext.Phase.PREPARED);
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            this.installTransformers(context);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.APPLICATION_PREPARED, context), false);
            if (!commandParams.enabled.booleanValue() || !this.domain.isCurrentInstanceMatchingTarget(commandParams.target, appName, this.server.getName(), (List)context.getTransientAppMetaData("previousTargets", List.class))) ** GOTO lbl-1000
            appInfo.setLibraries(commandParams.libraries());
            try {
                appInfo.load(context, tracker);
                appInfo.start(context, tracker);
            }
            catch (Exception loadException) {
                report.failure(this.logger, "Exception while loading the app", loadException);
                tracker.actOn(this.logger);
                var19_24 = null;
                Thread.currentThread().setContextClassLoader(currentCL);
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                    return var19_24;
                }
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                return var19_24;
            }
        }
lbl-1000:
        // 2 sources

        {
            var18_20 = appInfo;
            Thread.currentThread().setContextClassLoader(currentCL);
            if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                return var18_20;
            }
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
            return var18_20;
        }
    }

    public boolean suspend(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.suspend(this.logger);
        }
        return isSuccess;
    }

    public boolean resume(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.resume(this.logger);
        }
        return isSuccess;
    }

    public List<EngineInfo> setupContainerInfos(DeploymentContext context) throws Exception {
        return this.setupContainerInfos(null, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EngineInfo> setupContainerInfos(ArchiveHandler handler, Collection<? extends Sniffer> sniffers, DeploymentContext context) throws Exception {
        ActionReport report = context.getActionReport();
        if (sniffers == null) {
            ReadableArchive source = context.getSource();
            if (handler instanceof CompositeHandler) {
                context.getAppProps().setProperty("isComposite", "true");
                sniffers = this.snifferManager.getCompositeSniffers(context);
            } else {
                sniffers = this.snifferManager.getSniffers(source, context.getClassLoader());
            }
        }
        if (sniffers.size() == 0) {
            report.failure(this.logger, localStrings.getLocalString("deploy.unknownmoduletpe", "Module type not recognized for module {0}", new Object[]{context.getSourceDir()}));
            return null;
        }
        this.snifferManager.validateSniffers(sniffers, context);
        LinkedHashMap<Deployer, EngineInfo> containerInfosByDeployers = new LinkedHashMap<Deployer, EngineInfo>();
        for (Sniffer sniffer : sniffers) {
            String msg;
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null);
                return null;
            }
            Module snifferModule = this.modulesRegistry.find(sniffer.getClass());
            if (snifferModule == null) {
                report.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null);
                return null;
            }
            String containerName = sniffer.getContainersNames()[0];
            EngineInfo engineInfo = this.containerRegistry.getContainer(containerName);
            if (engineInfo == null) {
                Collection<EngineInfo> containersInfo = null;
                ContainerRegistry containerRegistry = this.containerRegistry;
                synchronized (containerRegistry) {
                    if (this.containerRegistry.getContainer(containerName) == null && ((containersInfo = this.setupContainer(sniffer, snifferModule, this.logger, context)) == null || containersInfo.size() == 0)) {
                        String msg2 = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                        report.failure(this.logger, msg2, null);
                        throw new Exception(msg2);
                    }
                }
                if (!this.startContainers(containersInfo, this.logger, context)) {
                    msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
            }
            if ((engineInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0])) == null) {
                String msg3 = "Aborting, Failed to start container " + containerName;
                report.failure(this.logger, msg3, null);
                throw new Exception(msg3);
            }
            Deployer deployer = this.getDeployer(engineInfo);
            if (deployer == null) {
                if (!this.startContainers(Collections.singleton(engineInfo), this.logger, context)) {
                    msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
                deployer = this.getDeployer(engineInfo);
                if (deployer == null) {
                    report.failure(this.logger, "Got a null deployer out of the " + engineInfo.getContainer().getClass() + " container, is it annotated with @Service ?");
                    return null;
                }
            }
            containerInfosByDeployers.put(deployer, engineInfo);
        }
        LinkedList providers = new LinkedList();
        providers.addAll(this.habitat.getAllByContract(ApplicationMetaDataProvider.class));
        ArrayList<EngineInfo> arrayList = new ArrayList<EngineInfo>();
        HashMap<Class, ApplicationMetaDataProvider> typeByProvider = new HashMap<Class, ApplicationMetaDataProvider>();
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class provided : provider.getMetaData().provides()) {
                typeByProvider.put(provided, provider);
            }
        }
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class dependency : provider.getMetaData().requires()) {
                if (typeByProvider.containsKey(dependency)) continue;
                this.logger.warning("ApplicationMetaDataProvider " + provider + " requires " + dependency + " but no other ApplicationMetaDataProvider provides it");
            }
        }
        HashMap<Class, Deployer> typeByDeployer = new HashMap<Class, Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class provided : deployer.getMetaData().provides()) {
                typeByDeployer.put(provided, deployer);
            }
        }
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class dependency : deployer.getMetaData().requires()) {
                if (typeByDeployer.containsKey(dependency) || typeByProvider.containsKey(dependency)) continue;
                Service s = deployer.getClass().getAnnotation(Service.class);
                String serviceName = s != null && s.name() != null && s.name().length() > 0 ? s.name() : deployer.getClass().getSimpleName();
                report.failure(this.logger, serviceName + " deployer requires " + dependency + " but no other deployer provides it", null);
                return null;
            }
        }
        ArrayList<Deployer> orderedDeployers = new ArrayList<Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Keyed Deployer " + deployer.getClass());
            }
            this.loadDeployer(orderedDeployers, deployer, typeByDeployer, typeByProvider, context);
        }
        for (Deployer deployer : orderedDeployers) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Ordered Deployer " + deployer.getClass());
            }
            MetaData metadata = deployer.getMetaData();
            try {
                if (metadata != null) {
                    if (metadata.provides() == null || metadata.provides().length == 0) {
                        deployer.loadMetaData(null, context);
                    } else {
                        for (Class provide : metadata.provides()) {
                            if (context.getModuleMetaData(provide) != null) continue;
                            context.addModuleMetaData(deployer.loadMetaData(provide, context));
                        }
                    }
                } else {
                    deployer.loadMetaData(null, context);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
            arrayList.add((EngineInfo)containerInfosByDeployers.get(deployer));
        }
        return arrayList;
    }

    private void loadDeployer(List<Deployer> results, Deployer deployer, Map<Class, Deployer> typeByDeployer, Map<Class, ApplicationMetaDataProvider> typeByProvider, DeploymentContext dc) throws IOException {
        if (results.contains(deployer)) {
            return;
        }
        results.add(deployer);
        if (deployer.getMetaData() != null) {
            for (Class required : deployer.getMetaData().requires()) {
                if (dc.getModuleMetaData(required) != null) continue;
                if (typeByDeployer.containsKey(required)) {
                    this.loadDeployer(results, typeByDeployer.get(required), typeByDeployer, typeByProvider, dc);
                    continue;
                }
                ApplicationMetaDataProvider provider = typeByProvider.get(required);
                if (provider == null) {
                    this.logger.severe("I don't get it, file a bug, no-one is providing " + required + " yet it passed validation");
                    continue;
                }
                LinkedList<ApplicationMetaDataProvider> providers = new LinkedList<ApplicationMetaDataProvider>();
                this.addRecursively(providers, typeByProvider, provider);
                for (ApplicationMetaDataProvider p : providers) {
                    dc.addModuleMetaData(p.load(dc));
                }
            }
        }
    }

    private void addRecursively(LinkedList<ApplicationMetaDataProvider> results, Map<Class, ApplicationMetaDataProvider> providers, ApplicationMetaDataProvider provider) {
        results.addFirst(provider);
        for (Class type : provider.getMetaData().requires()) {
            if (!providers.containsKey(type)) continue;
            this.addRecursively(results, providers, providers.get(type));
        }
    }

    public ModuleInfo prepareModule(List<EngineInfo> sortedEngineInfos, String moduleName, DeploymentContext context, ProgressTracker tracker) throws Exception {
        String isComposite;
        ActionReport report = context.getActionReport();
        ArrayList<EngineRef> addedEngines = new ArrayList<EngineRef>();
        for (EngineInfo engineInfo : sortedEngineInfos) {
            Deployer deployer = engineInfo.getDeployer();
            try {
                deployer.prepare(context);
                EngineRef engineRef = new EngineRef(engineInfo, null);
                addedEngines.add(engineRef);
                tracker.add("prepared", EngineRef.class, (Object)engineRef);
                tracker.add(Deployer.class, (Object)deployer);
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event<DeploymentContext>(Deployment.MODULE_PREPARED, context), false);
        }
        if ((isComposite = context.getAppProps().getProperty("isComposite")) != null) {
            context.getModuleProps().setProperty("isComposite", isComposite);
        }
        ModuleInfo mi = new ModuleInfo(this.events, moduleName, addedEngines, context.getModuleProps());
        ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(context.getAppProps());
        for (EngineRef er : mi.getEngineRefs()) {
            ApplicationConfig c = savedAppConfig.get(mi.getName(), er.getContainerInfo().getSniffer().getModuleType());
            if (c == null) continue;
            er.setApplicationConfig(c);
        }
        return mi;
    }

    protected Collection<EngineInfo> setupContainer(Sniffer sniffer, Module snifferModule, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        ContainerStarter starter = (ContainerStarter)this.habitat.getComponent(ContainerStarter.class);
        Collection<EngineInfo> containersInfo = starter.startContainer(sniffer, snifferModule);
        if (containersInfo == null || containersInfo.size() == 0) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    protected boolean startContainers(Collection<EngineInfo> containersInfo, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        for (EngineInfo engineInfo : containersInfo) {
            Container container;
            try {
                container = engineInfo.getContainer();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot start container  " + engineInfo.getSniffer().getModuleType(), e);
                return false;
            }
            Class<? extends Deployer> deployerClass = container.getDeployer();
            try {
                Deployer deployer = (Deployer)this.habitat.getComponent(deployerClass);
                engineInfo.setDeployer(deployer);
            }
            catch (ComponentException e) {
                report.failure(logger, "Cannot instantiate or inject " + deployerClass, e);
                engineInfo.stop(logger);
                return false;
            }
            catch (ClassCastException e) {
                engineInfo.stop(logger);
                report.failure(logger, deployerClass + " does not implement " + " the org.jvnet.glassfish.api.deployment.Deployer interface", e);
                return false;
            }
        }
        return true;
    }

    protected void stopContainers(EngineInfo[] ctrInfos, Logger logger) {
        for (EngineInfo ctrInfo : ctrInfos) {
            try {
                ctrInfo.stop(logger);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Cannot release container " + ctrInfo.getSniffer().getModuleType(), e);
            }
        }
    }

    protected ApplicationInfo unload(String appName, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            return null;
        }
        info.stop(context, context.getLogger());
        info.unload(context);
        return info;
    }

    public void undeploy(String appName, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
            return;
        }
        this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_VALIDATION, context), false);
        if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            return;
        }
        this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.UNDEPLOYMENT_START, info));
        try {
            info.clean(context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while cleaning application artifacts", e);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
            return;
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_SUCCESS, context));
        } else {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
        }
        this.appRegistry.remove(appName);
        info = null;
    }

    public Transaction prepareAppConfigChanges(DeploymentContext context) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        Transaction t = new Transaction();
        try {
            ConfigBean newBean = ((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)this.applications)).allocate(Application.class);
            Application app = (Application)newBean.createProxy();
            Application app_w = t.enroll(app);
            this.setInitialAppAttributes(app_w, deployParams, appProps);
            context.addTransientAppMetaData("application", app_w);
        }
        catch (TransactionFailure e) {
            t.rollback();
            throw e;
        }
        catch (Exception e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), e);
        }
        return t;
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t) throws TransactionFailure {
        this.registerAppInDomainXML(applicationInfo, context, t, false);
    }

    public void registerAppInDomainXML(ApplicationInfo applicationInfo, DeploymentContext context, Transaction t, boolean appRefOnly) throws TransactionFailure {
        Properties appProps = context.getAppProps();
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        if (t != null) {
            try {
                if (!appRefOnly) {
                    Application app_w = context.getTransientAppMetaData("application", Application.class);
                    this.setRestAppAttributes(app_w, appProps);
                    Applications apps_w = t.enroll(this.applications);
                    apps_w.getModules().add(app_w);
                    if (applicationInfo != null) {
                        applicationInfo.save(app_w);
                    }
                }
                List<String> targets = new ArrayList<String>();
                if (!deployParams.target.equals("domain")) {
                    targets.add(deployParams.target);
                } else {
                    List previousTargets = context.getTransientAppMetaData("previousTargets", List.class);
                    if (previousTargets == null) {
                        previousTargets = this.domain.getAllReferencedTargetsForApplication(deployParams.name);
                    }
                    targets = previousTargets;
                }
                for (String target : targets) {
                    Cluster cluster;
                    Server servr = this.domain.getServerNamed(target);
                    if (servr != null) {
                        Server servr_w = t.enroll(servr);
                        ApplicationRef appRef = servr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef, deployParams);
                        servr_w.getApplicationRef().add(appRef);
                    }
                    if ((cluster = this.domain.getClusterNamed(target)) == null) continue;
                    Cluster cluster_w = t.enroll(cluster);
                    ApplicationRef appRef = cluster_w.createChild(ApplicationRef.class);
                    this.setAppRefAttributes(appRef, deployParams);
                    cluster_w.getApplicationRef().add(appRef);
                    for (Server svr : cluster.getInstances()) {
                        Server svr_w = t.enroll(svr);
                        ApplicationRef appRef2 = svr_w.createChild(ApplicationRef.class);
                        this.setAppRefAttributes(appRef2, deployParams);
                        svr_w.getApplicationRef().add(appRef2);
                    }
                }
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
            catch (Exception e) {
                t.rollback();
                throw new TransactionFailure(e.getMessage(), e);
            }
            try {
                t.commit();
            }
            catch (RetryableException e) {
                System.out.println("Retryable...");
                t.rollback();
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
        }
    }

    private void setInitialAppAttributes(Application app, DeployCommandParameters deployParams, Properties appProps) throws PropertyVetoException {
        app.setName(deployParams.name);
        if (deployParams.libraries != null) {
            app.setLibraries(deployParams.libraries);
        }
        if (deployParams.description != null) {
            app.setDescription(deployParams.description);
        }
        if (appProps.getProperty("location") != null) {
            app.setLocation(appProps.getProperty("location"));
            app.setEnabled(String.valueOf(true));
            app.setAvailabilityEnabled(deployParams.availabilityenabled.toString());
        } else {
            app.setEnabled(deployParams.enabled.toString());
        }
        if (appProps.getProperty("object-type") != null) {
            app.setObjectType(appProps.getProperty("object-type"));
        }
        if (appProps.getProperty("directory-deployed") != null) {
            app.setDirectoryDeployed(appProps.getProperty("directory-deployed"));
        }
    }

    private void setRestAppAttributes(Application app, Properties appProps) throws PropertyVetoException, TransactionFailure {
        if (appProps.getProperty("context-root") != null) {
            app.setContextRoot(appProps.getProperty("context-root"));
        }
        for (String string : appProps.keySet()) {
            if (string.equals("location") || string.equals("context-root") || string.equals("object-type") || string.equals("directory-deployed") || string.startsWith("appConfig")) continue;
            Property prop = (Property)app.createChild(Property.class);
            app.getProperty().add(prop);
            prop.setName(string);
            prop.setValue(appProps.getProperty(string));
        }
    }

    public void unregisterAppFromDomainXML(String appName, String target) throws TransactionFailure {
        this.unregisterAppFromDomainXML(appName, target, false);
    }

    public void unregisterAppFromDomainXML(final String appName, final String tgt, final boolean appRefOnly) throws TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction(param);
                if (t != null) {
                    List<String> targets = new ArrayList<String>();
                    if (!tgt.equals("domain")) {
                        targets.add(tgt);
                    } else {
                        targets = ApplicationLifecycle.this.domain.getAllReferencedTargetsForApplication(appName);
                    }
                    for (String target : targets) {
                        Cluster cluster;
                        Server servr = ((Domain)param).getServerNamed(target);
                        if (servr != null) {
                            Server servr_w = t.enroll(servr);
                            for (ApplicationRef appRef : servr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                servr_w.getApplicationRef().remove(appRef);
                                break;
                            }
                        }
                        if ((cluster = ((Domain)param).getClusterNamed(target)) == null) continue;
                        Cluster cluster_w = t.enroll(cluster);
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            cluster_w.getApplicationRef().remove(appRef);
                            break;
                        }
                        block3: for (Server svr : cluster.getInstances()) {
                            Server svr_w = t.enroll(svr);
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                svr_w.getApplicationRef().remove(appRef);
                                continue block3;
                            }
                        }
                    }
                    if (!appRefOnly) {
                        Applications apps = ((Domain)param).getApplications();
                        Applications apps_w = t.enroll(apps);
                        for (ApplicationName module : apps.getModules()) {
                            if (!module.getName().equals(appName)) continue;
                            apps_w.getModules().remove(module);
                            break;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, this.domain);
    }

    public void updateAppEnabledAttributeInDomainXML(final String appName, final String target, final boolean enabled) throws TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction(param);
                if (t != null) {
                    Cluster cluster;
                    if (enabled || target.equals("domain")) {
                        Application app = ((Domain)param).getApplications().getApplication(appName);
                        Application app_w = t.enroll(app);
                        app_w.setEnabled(String.valueOf(enabled));
                    }
                    if (target.equals("domain")) {
                        return Boolean.TRUE;
                    }
                    Server servr = ((Domain)param).getServerNamed(target);
                    if (servr != null) {
                        for (ApplicationRef appRef : servr.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ApplicationRef appRef_w = t.enroll(appRef);
                            appRef_w.setEnabled(String.valueOf(enabled));
                            break;
                        }
                        ApplicationLifecycle.this.updateClusterAppRefWithInstanceUpdate(t, servr, appName, enabled);
                    }
                    if ((cluster = ((Domain)param).getClusterNamed(target)) != null) {
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ApplicationRef appRef_w = t.enroll(appRef);
                            appRef_w.setEnabled(String.valueOf(enabled));
                            break;
                        }
                        block2: for (Server svr : cluster.getInstances()) {
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ApplicationRef appRef_w = t.enroll(appRef);
                                appRef_w.setEnabled(String.valueOf(enabled));
                                continue block2;
                            }
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, this.domain);
    }

    public boolean isRegistered(String appName) {
        return this.applications.getApplication(appName) != null;
    }

    public ApplicationInfo get(String appName) {
        return this.appRegistry.get(appName);
    }

    public Deployment.DeploymentContextBuilder getBuilder(Logger logger, OpsParams params, ActionReport report) {
        return new DeploymentContextBuidlerImpl(logger, params, report);
    }

    private void updateClusterAppRefWithInstanceUpdate(Transaction t, Server servr, String appName, boolean isNewInstanceAppRefStateEnabled) throws TransactionFailure, PropertyVetoException {
        Cluster clusterContainingInstance = servr.getCluster();
        if (clusterContainingInstance != null) {
            boolean isAppRefEnabledOnAnyClusterInstance = false;
            for (Server inst : clusterContainingInstance.getInstances()) {
                isAppRefEnabledOnAnyClusterInstance |= servr.getName().equals(inst.getName()) ? isNewInstanceAppRefStateEnabled : Boolean.parseBoolean(inst.getApplicationRef(appName).getEnabled());
            }
            ApplicationRef clusterAppRef = clusterContainingInstance.getApplicationRef(appName);
            if (Boolean.parseBoolean(clusterAppRef.getEnabled()) != isAppRefEnabledOnAnyClusterInstance) {
                t.enroll(clusterAppRef).setEnabled(String.valueOf(isAppRefEnabledOnAnyClusterInstance));
            }
        }
    }

    private ReadableArchive getArchive(Deployment.DeploymentContextBuilder builder) throws IOException {
        ReadableArchive archive = builder.sourceAsArchive();
        if (archive == null && builder.sourceAsFile() == null) {
            throw new IOException("Source archive or file not provided to builder");
        }
        if (archive == null && builder.sourceAsFile() != null && (archive = ((ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class)).openArchive(builder.sourceAsFile())) == null) {
            throw new IOException("Invalid archive type : " + builder.sourceAsFile().getAbsolutePath());
        }
        return archive;
    }

    private ExtendedDeploymentContext getContext(ExtendedDeploymentContext initial, Deployment.DeploymentContextBuilder builder) throws IOException {
        ArchiveHandler archiveHandler;
        DeploymentContextBuidlerImpl copy = new DeploymentContextBuidlerImpl(builder);
        ReadableArchive archive = this.getArchive(copy);
        copy.source(archive);
        if (initial == null) {
            initial = new DeploymentContextImpl((Deployment.DeploymentContextBuilder)copy, (ServerEnvironment)this.env);
        }
        if ((archiveHandler = copy.archiveHandler()) == null) {
            archiveHandler = this.getArchiveHandler(archive);
        }
        File sourceFile = new File(archive.getURI().getSchemeSpecificPart());
        initial.getAppProps().put("defaultAppName", DeploymentUtils.getDefaultEEName((String)sourceFile.getName()));
        if (!sourceFile.isDirectory()) {
            String repositoryBitName = copy.params().name();
            try {
                repositoryBitName = VersioningDeploymentUtil.getRepositoryName((String)repositoryBitName);
            }
            catch (VersioningDeploymentSyntaxException e) {
                ActionReport report = copy.report();
                report.setMessage(e.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            File expansionDir = new File(this.domain.getApplicationRoot(), repositoryBitName);
            if (!expansionDir.mkdirs()) {
                this.logger.fine(localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
            }
            try {
                Long start = System.currentTimeMillis();
                archiveHandler.expand(archive, this.archiveFactory.createArchive(expansionDir), (DeploymentContext)initial);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Deployment expansion took " + (System.currentTimeMillis() - start));
                }
                try {
                    archive.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorclosingarchive", "Error while closing deployable artifact {0}", new Object[]{archive.getURI().getSchemeSpecificPart()}), e);
                    throw e;
                }
                archive = this.archiveFactory.openArchive(expansionDir);
                initial.setSource(archive);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorexpandingjar", "Error while expanding archive file"), e);
                throw e;
            }
        }
        initial.setArchiveHandler(archiveHandler);
        return initial;
    }

    private String getVirtualServers(String target) {
        List hosts;
        HttpService httpService;
        if (this.env.isDas() && target.equals("domain")) {
            target = "server";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Server server = this.domain.getServerNamed(target);
        Config config = null;
        if (server != null) {
            config = this.domain.getConfigs().getConfigByName(server.getConfigRef());
        } else {
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null) {
                config = this.domain.getConfigs().getConfigByName(cluster.getConfigRef());
            }
        }
        if (config != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }

    private void setAppRefAttributes(ApplicationRef appRef, DeployCommandParameters deployParams) throws PropertyVetoException {
        appRef.setRef(deployParams.name);
        if (deployParams.virtualservers != null) {
            appRef.setVirtualServers(deployParams.virtualservers);
        } else {
            HttpService httpService = (HttpService)this.habitat.getComponent(HttpService.class);
            StringBuilder sb = new StringBuilder();
            for (VirtualServer s : httpService.getVirtualServer()) {
                if (s.getId().equals("__asadmin")) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s.getId());
            }
            appRef.setVirtualServers(sb.toString());
        }
        appRef.setLbEnabled(deployParams.lbenabled.toString());
        appRef.setEnabled(deployParams.enabled.toString());
    }

    public List<Sniffer> prepareSniffersForOSGiDeployment(String type, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        StringTokenizer st = new StringTokenizer(type);
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        while (st.hasMoreTokens()) {
            String aType = st.nextToken();
            Sniffer sniffer = this.snifferManager.getSniffer(aType);
            if (sniffer == null) {
                report.failure(logger, localStrings.getLocalString("deploy.unknowncontainer", "{0} is not a recognized container ", (Object[])new String[]{aType}));
                return sniffers;
            }
            if (!this.snifferManager.canBeIsolated(sniffer)) {
                report.failure(logger, localStrings.getLocalString("deploy.isolationerror", "container {0} does not support other components containers to be turned off, --type {0} is forbidden", (Object[])new String[]{aType}));
                return sniffers;
            }
            sniffers.add(sniffer);
        }
        return sniffers;
    }

    public ParameterMap prepareInstanceDeployParamMap(DeploymentContext dc) throws Exception {
        DeployCommandParameters params = dc.getCommandParameters(DeployCommandParameters.class);
        ArrayList<String> excludedParams = new ArrayList<String>();
        excludedParams.add("path");
        excludedParams.add("deploymentplan");
        excludedParams.add("upload");
        ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{params});
        ParameterMap paramMap = extractor.extract(excludedParams);
        File genPolicyDir = dc.getScratchDir("policy");
        if (genPolicyDir.isDirectory()) {
            paramMap.set("generatedpolicydir", dc.getScratchDir("policy").getAbsolutePath());
        }
        paramMap.set("generatedxmldir", dc.getScratchDir("xml").getAbsolutePath());
        paramMap.set("generatedejbdir", dc.getScratchDir("ejb").getAbsolutePath());
        paramMap.set("generatedjspdir", dc.getScratchDir("jsp").getAbsolutePath());
        Application application = this.applications.getApplication(params.name);
        Properties appProperties = application.getDeployProperties();
        String archiveLocation = appProperties.getProperty("appLocation");
        File archiveFile = new File(new URI(archiveLocation));
        paramMap.set("DEFAULT", archiveFile.getAbsolutePath());
        String planLocation = appProperties.getProperty("deploymentPlanLocation");
        if (planLocation != null) {
            File actualPlan = new File(new URI(planLocation));
            paramMap.set("deploymentplan", actualPlan.getAbsolutePath());
        }
        paramMap.set("upload", Boolean.toString(!archiveFile.isDirectory()));
        if (params.previousContextRoot != null) {
            paramMap.set("preservedcontextroot", params.previousContextRoot);
        }
        Properties appProps = dc.getAppProps();
        appProps.remove("appConfig");
        paramMap.set("appprops", extractor.propertiesValue(appProps, ':'));
        return paramMap;
    }

    public void validateDeploymentTarget(String target, String name, boolean isRedeploy) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.isEmpty()) {
            if (this.isRegistered(name) && !isRedeploy && target.equals("domain")) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
            }
            return;
        }
        if (!isRedeploy) {
            if (target.equals("domain")) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.deploy_domain", "Application with name {0} is already referenced by other target(s). Please specify force option to redeploy to domain.", new Object[]{name}));
            }
            if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
                throw new IllegalArgumentException(localStrings.getLocalString("application.alreadyreg.redeploy", "Application with name {0} is already registered. Either specify that redeployment must be forced, or redeploy the application. Or if this is a new deployment, pick a different name.", new Object[]{name}));
            }
            throw new IllegalArgumentException(localStrings.getLocalString("use.create_app_ref", "Application {0} is already referenced by other target(s). Please use create application ref to create application reference on target {1}.", new Object[]{name, target}));
        }
        if (referencedTargets.size() == 1 && referencedTargets.contains(target)) {
            return;
        }
        if (!target.equals("domain")) {
            throw new IllegalArgumentException(localStrings.getLocalString("redeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove all references or specify all targets (or domain target if using asadmin command line) before attempting redeploy operation.", new Object[]{name}));
        }
    }

    public void validateUndeploymentTarget(String target, String name) {
        List referencedTargets = this.domain.getAllReferencedTargetsForApplication(name);
        if (referencedTargets.size() > 1 && !target.equals("domain")) {
            throw new IllegalArgumentException(localStrings.getLocalString("undeploy_on_multiple_targets", "Application {0} is referenced by more than one targets. Please remove all references or specify all targets (or domain target if using asadmin command line) before attempting undeploy operation.", new Object[]{name}));
        }
    }

    public boolean isAppEnabled(Application app) {
        ApplicationRef appRef;
        return Boolean.valueOf(app.getEnabled()) != false && (appRef = this.server.getApplicationRef(app.getName())) != null && Boolean.valueOf(appRef.getEnabled()) != false;
    }

    public void disable(String appName, String target, Application app, ApplicationInfo appInfo, ActionReport report, Logger logger, Boolean keepstate, Properties properties) throws Exception {
        UndeployCommandParameters commandParams = new UndeployCommandParameters();
        commandParams.origin = OpsParams.Origin.unload;
        commandParams.name = appName;
        commandParams.target = target;
        if (keepstate != null) {
            commandParams.keepstate = keepstate;
        }
        ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, commandParams, report).source(appInfo.getSource()).build();
        deploymentContext.getAppProps().putAll((Map<?, ?>)app.getDeployProperties());
        deploymentContext.setModulePropsMap(app.getModulePropertiesMap());
        if (properties != null) {
            deploymentContext.getAppProps().putAll((Map<?, ?>)properties);
        }
        appInfo.stop(deploymentContext, deploymentContext.getLogger());
        appInfo.unload(deploymentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(String target, Application app, ApplicationRef appRef, ActionReport report, Logger logger) throws Exception {
        Archive archive = null;
        try {
            DeployCommandParameters commandParams = app.getDeployParameters(appRef);
            commandParams.origin = OpsParams.Origin.load;
            commandParams.target = target;
            Properties contextProps = app.getDeployProperties();
            Map modulePropsMap = app.getModulePropertiesMap();
            ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(app);
            URI uri = new URI(app.getLocation());
            File file = new File(uri);
            if (!file.exists()) {
                throw new Exception(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
            }
            archive = this.archiveFactory.openArchive(file);
            ExtendedDeploymentContext deploymentContext = this.getBuilder(logger, commandParams, report).source((ReadableArchive)archive).build();
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)contextProps);
            savedAppConfig.store(appProps);
            if (modulePropsMap != null) {
                deploymentContext.setModulePropsMap(modulePropsMap);
            }
            this.deploy(deploymentContext);
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void installTransformers(ExtendedDeploymentContext appContext) throws Exception {
        this.installTransformersOnModule(appContext, true);
        Map moduleContexts = appContext.getModuleDeploymentContexts();
        for (String moduleUri : moduleContexts.keySet()) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)moduleContexts.get(moduleUri);
            this.installTransformersOnModule(context, false);
        }
    }

    private void installTransformersOnModule(ExtendedDeploymentContext context, boolean isAppLevel) throws Exception {
        ActionReport report = context.getActionReport();
        if (!context.getTransformers().isEmpty()) {
            try {
                InstrumentableClassLoader icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(context.getFinalClassLoader());
                String isComposite = context.getAppProps().getProperty("isComposite");
                if (Boolean.valueOf(isComposite).booleanValue() && icl instanceof URLClassLoader) {
                    URLClassLoader urlCl = (URLClassLoader)((Object)icl);
                    if (isAppLevel) {
                        icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(urlCl.getParent().getParent());
                    } else {
                        ClassLoader libCl = urlCl.getParent().getParent();
                        if (!(libCl instanceof URLClassLoader)) {
                            libCl = libCl.getParent();
                        }
                        if (libCl instanceof URLClassLoader) {
                            InstrumentableClassLoader libIcl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(libCl);
                            for (ClassFileTransformer transformer : context.getTransformers()) {
                                libIcl.addTransformer(transformer);
                            }
                        }
                    }
                }
                for (ClassFileTransformer transformer : context.getTransformers()) {
                    icl.addTransformer(transformer);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Class loader used for loading application cannot handle bytecode enhancer", e);
                throw e;
            }
        }
    }

    public class DeploymentContextBuidlerImpl
    implements Deployment.DeploymentContextBuilder {
        private final Logger logger;
        private final ActionReport report;
        private final OpsParams params;
        private File sFile;
        private ReadableArchive sArchive;
        private ArchiveHandler handler;

        public DeploymentContextBuidlerImpl(Logger logger, OpsParams params, ActionReport report) {
            this.logger = logger;
            this.report = report;
            this.params = params;
        }

        public DeploymentContextBuidlerImpl(Deployment.DeploymentContextBuilder b) throws IOException {
            this.logger = b.logger();
            this.report = b.report();
            this.params = b.params();
            ReadableArchive archive = ApplicationLifecycle.this.getArchive(b);
            this.source(archive);
            this.handler = b.archiveHandler();
        }

        public Deployment.DeploymentContextBuilder source(File source) {
            this.sFile = source;
            return this;
        }

        public File sourceAsFile() {
            return this.sFile;
        }

        public ReadableArchive sourceAsArchive() {
            return this.sArchive;
        }

        public ArchiveHandler archiveHandler() {
            return this.handler;
        }

        public Deployment.DeploymentContextBuilder source(ReadableArchive archive) {
            this.sArchive = archive;
            return this;
        }

        public Deployment.DeploymentContextBuilder archiveHandler(ArchiveHandler handler) {
            this.handler = handler;
            return this;
        }

        public ExtendedDeploymentContext build() throws IOException {
            return this.build(null);
        }

        public Logger logger() {
            return this.logger;
        }

        public ActionReport report() {
            return this.report;
        }

        public OpsParams params() {
            return this.params;
        }

        public ExtendedDeploymentContext build(ExtendedDeploymentContext initialContext) throws IOException {
            return ApplicationLifecycle.this.getContext(initialContext, this);
        }
    }
}

